<?php
	date_default_timezone_set('America/Lima');

//Local
if($_SERVER["SERVER_NAME"] == "localhost"){
    define("DB_HOST", "localhost");
    define("DB_NAME", "panelpublicidad");
    define("DB_PORT", "3307");
    define("DB_USERNAME", "root");
    define("DB_PASSWORD", "");
} else {
    define("DB_HOST", "localhost");
    define("DB_NAME", "dardocom_publicidad");
    define("DB_PORT", "3306");
    define("DB_USERNAME", "dardocom_publici");
    define("DB_PASSWORD", "Publicidad191!-!");
}
	//Display de errores
	ini_set("display_errors", true);
	//Core
    require 'definitions.php';
	require 'core/DB.php';
	require 'core/DBOCrud.php';
	require 'core/EntityBase.php';
	require_once 'core/Security.php';
	require_once 'Slim/Slim.php';	

	/**
	* Definicio de constantes del sistema
	*/
	defined('APP_NAME') || define('APP_NAME', 'webpublicidad');
	defined('CDN_BASE') || define('CDN_BASE','./');
	defined('WWW_BASE') || define('WWW_BASE','./');
	defined('APP_VERSION') || define('APP_VERSION', 'v0.0');
	defined('MODULE_NAME') || define('MODULE_NAME', 'MyApp');
	defined('APP_DEBUG') || define('APP_DEBUG', true);
	defined('APP_THEME') || define('APP_THEME', '');
    defined('APP_MULTISUCURSAL') || define('APP_MULTISUCURSAL', '0');
	defined('SEND_ERRORS') || define('SEND_ERRORS', true);
	define("LIMIT_RESULT", 200);

	//Variables Globales de Notificaciones
	define("SUCCESS",1);
	define("ERROR",2);
	define("WARNING",3);
	define("INFO",4);
	define("NOPERMITIDO",401);
	define("ACTIVO",1);
	define("INACTIVO",0);
	

	/* * **inicio Coneccion a la DB** */
	
	$db = DB::getInstance();
	$pdo = $db->dbh;
	if ($db != NULL && $db != "") {
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}

	session_cache_limiter(false);
	session_start();

	/* * **inicio de idiomas** */
	
	$accept_languages = array("es");
	$sitelang = getenv("HTTP_ACCEPT_LANGUAGE");
	$iso_lang = substr($sitelang, 0, 2);
	$lang = "es";
	if (!isset($_COOKIE['lg'])) {
		foreach ($accept_languages as $language) {
			if ($iso_lang == $language) {
				$lang = $iso_lang;
				break;
			}
		}
	} else {
		$lang = $_COOKIE['lg'];
	}
	defined('APP_LANG') || define('APP_LANG', $lang);
	
	/* * *fin de idiomas***** */


	spl_autoload_register(function($classname) {
		$filename = $classname . ".php";
		if (file_exists(PATH . "entities/" . $filename)) {
			include_once(PATH . "entities/" . $filename);
		} else if (file_exists(PATH . "models/" . $filename)) {
			include_once(PATH . "models/" . $filename);
		} else if (file_exists(PATH . "controllers/" . $filename)) {
			include_once(PATH . "controllers/" . $filename);
		} else if (file_exists(PATH . "core/" . $filename)) {
			include_once(PATH . "core/" . $filename);
		} else if (file_exists(PATH . "entities/" . ucfirst($filename))) {
			include_once(PATH . "entities/" . ucfirst($filename));
		} else if (file_exists(PATH . "models/" . ucfirst($filename))) {
			include_once(PATH . "models/" . ucfirst($filename));
		} else if (file_exists(PATH . "controllers/" . ucfirst($filename))) {
			include_once(PATH . "controllers/" . ucfirst($filename));
		} else if (file_exists(PATH . "core/" . ucfirst($filename))) {
			include_once(PATH . "core/" . ucfirst($filename));
		} else if (file_exists(PATH . "utils/" . ucfirst($filename))) {
			include_once(PATH . "utils/" . ucfirst($filename));
		}else if (file_exists(PATH . "core/libs/PHPMailer/" .'class.'.strtolower($classname).'.php')) {
            include_once(PATH . "core/libs/PHPMailer/" .'class.'.strtolower($classname).'.php');
        } else {
			//FIX para que funcione con Slim
			\Slim\Slim::autoload($classname);
		}
	});

	require_once(PATH . "core/libs/JWT/JWT.php");

	require_once(PATH . "core/libs/PHPImageWorkshop/Exception/ImageWorkshopBaseException.php");
	require_once(PATH . "core/libs/PHPImageWorkshop/Exception/ImageWorkshopException.php");
	require_once(PATH . "core/libs/PHPImageWorkshop/Core/Exception/ImageWorkshopLayerException.php");
	require_once(PATH . "core/libs/PHPImageWorkshop/Core/ImageWorkshopLib.php");
	require_once(PATH . "core/libs/PHPImageWorkshop/Core/ImageWorkshopLayer.php");
	require_once(PATH . "core/libs/PHPImageWorkshop/ImageWorkshop.php");



    function handle_exception($exception)
    {
        echo "Ha ocurrido un problema, por favor int&eacute;ntelo m&aacute;s tarde " .$exception;
        error_log($exception->getMessage());
    }

    set_exception_handler('handle_exception');

?>