<?php
class ArchivoelementoController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$archivoelemento_array = Archivoelemento::getList();
		$datos = $archivoelemento_array["archivoelemento_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($archivoelemento) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$archivoelemento = new Archivoelemento($archivoelemento);
			$resultado= $archivoelemento->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$archivoelemento){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$archivoelementoObj = new Archivoelemento($archivoelemento);
			$archivoelementoObj->setArchivoelemento_id($id);
			$resultado=$archivoelementoObj->update();
			if ($resultado) {
                $elemento = Elemento::getById($archivoelemento->elemento_id);
			    if($elemento){
                    $elemento->elemento_estavencido = NO;
                    $elemento->update();
                }
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Archivoelemento::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$archivoelementoObj = Archivoelemento::getById($id);
			$archivoelementoObj->setArchivoelemento_estado(INACTIVO);
			$resultado=$archivoelementoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getArchivoelementoListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$archivoelemento_array = Archivoelemento::getList(array(),(($pagina - 1) * $registros),$registros);
		$archivoelemento_array = $archivoelemento_array["archivoelemento_array"];
		$array_data["archivoelementoList"] = $archivoelemento_array;
		$array_data["archivoelementoCount"] = Archivoelemento::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>