<?php
class ElementoController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$elemento_array = Elemento::getList();
		$datos = $elemento_array["elemento_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($elemento) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";

        $elemento = new Elemento($elemento);

        if($elemento->elemento_id*1>0){
            $mensajes[] = "Error, posiblemente el elemento ya haya sido regiostrado";
            $tipo = ERROR;
        }

		if (empty($mensajes)) {

		    $array_imagenes = array();


            $codigoUnico = "elemento-" . Date("YmdHis");
			$elemento->setElemento_codigounico(trim($codigoUnico));

            if(isset($elemento->listaImagenes)){
                $array_imagenes = $elemento->listaImagenes;
            }

            if(isset($elemento->listaArchivos)){
                $array_archivos = $elemento->listaArchivos;
            }

			$resultado= $elemento->insert();

			if ($resultado) {

			    foreach ($array_imagenes as $imagen){
			        $imagenElemento = new Imagenelemento();
			        $imagenElemento->setImagenelemento_url($imagen->imagenelemento_url);
			        $imagenElemento->setImagenelemento_estado(ACTIVO);
			        $imagenElemento->setElemento_id($resultado);
                    $imagenElemento->insert();
                }

                foreach ($array_archivos as $archivo){
                    $archivoElemento = new Archivoelemento();
                    $archivoElemento->setElemento_id($resultado);
                    $archivoElemento->setArchivoelemento_estadodoc($archivo->archivoelemento_estadodoc);
                    $archivoElemento->setArchivoelemento_estado(ACTIVO);
                    $archivoElemento->setArchivoelemento_url($archivo->archivoelemento_url);
                    $archivoElemento->setArchivoelemento_fechavencimiento($archivo->archivoelemento_fechavencimiento);
                    $archivoElemento->setArchivoelemento_tipo($archivo->archivoelemento_tipo);
                    $archivoElemento->insert();
                }

				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$elemento){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {

            $array_archivos = array();

            $elementoObj = new Elemento($elemento);

            if(isset($elementoObj->listaArchivos)){
                $array_archivos = $elementoObj->listaArchivos;
            }

            $elementoObj->setElemento_id($id);
			$resultado=$elementoObj->update();

			if ($resultado) {

                foreach ($array_archivos as $archivo){
                    $archivoElemento = new Archivoelemento();
                    $archivoElemento->setArchivoelemento_id($archivo->archivoelemento_id);
                    $archivoElemento->setElemento_id($archivo->elemento_id);
                    $archivoElemento->setArchivoelemento_estadodoc($archivo->archivoelemento_estadodoc);
                    $archivoElemento->setArchivoelemento_estado($archivo->archivoelemento_estado);
                    $archivoElemento->setArchivoelemento_url($archivo->archivoelemento_url);
                    $archivoElemento->setArchivoelemento_fechavencimiento($archivo->archivoelemento_fechavencimiento);
                    $archivoElemento->setArchivoelemento_tipo($archivo->archivoelemento_tipo);
                    $archivoElemento->update();
                }

				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
        $datos = null;

        $obj = Elemento::getById($id);

        if($obj){
            $obj->campania = Campania::getById($obj->campania_id);
            $obj->subtipo = Subtipo::getById($obj->subtipo_id);
            $obj->tipo = Tipo::getById($obj->subtipo->tipo_id);

            $obj->listaImagenes = Imagenelemento::getByFields(array(
               array("field"=>"elemento_id","value"=>$obj->elemento_id, "operator"=>"="),
               array("field"=>"imagenelemento_estado","value"=>ACTIVO, "operator"=>"=")
            ))["imagenelemento_array"];

            $obj->archivosElemento = Archivoelemento::getByFields(array(
                array("field"=>"elemento_id","value"=>$obj->elemento_id, "operator"=>"="),
                array("field"=>"archivoelemento_estado","value"=>ACTIVO, "operator"=>"=")
            ))["archivoelemento_array"];

            $datos = $obj;
        }else{
            $tipo = ERROR;
        }


		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$elementoObj = Elemento::getById($id);
			$elementoObj->setElemento_estado(INACTIVO);
			$resultado=$elementoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

    public function obtenerListaElementosParaWeb($distrito,$subtipo,$estado){

        $data = array();
        $tipo = SUCCESS;

        // OPTIMIZACIÓN: Usar query con JOINs y cálculo de vencimiento en tiempo real
        // Elimina N+1 queries y UPDATE statements que causaban array vacío
        $elemento_array = Elemento::obtenerListaElementosOptimizado($distrito,$subtipo,$estado);

        // Agregar campo tipoelemento para compatibilidad con el frontend
        foreach ($elemento_array as $elemento){
            // subtipo y distrito ya vienen del JOIN optimizado
            // Solo necesitamos agregar tipoelemento
            if(isset($elemento->subtipo->tipo_id)){
                $elemento->tipoelemento = Tipo::getById($elemento->subtipo->tipo_id);
            }
        }

        $array_data["elementoList"] = $elemento_array;
        $array_data["elementoCount"] = Elemento::getTotalRows();
        $datos = $array_data;
        $data["tipo"] = $tipo;
        $data["datos"] = $datos;
        return $data;
    }

    public function obtenerElementoParaWeb($elemento_id){

        $data = array();
        $tipo = SUCCESS;
        $datos = null;

        $obj = Elemento::getById($elemento_id);

        if($obj){

            $obj->campania = Campania::getById($obj->campania_id);
            $obj->subTipoElemento = Subtipo::getById($obj->subtipo_id);
            $obj->tipoElemento = Tipo::getById($obj->subTipoElemento->tipo_id);

            $obj->listaImagenes = Imagenelemento::getByFields(array(
                array("field"=>"elemento_id","value"=>$obj->elemento_id, "operator"=>"="),
                array("field"=>"imagenelemento_estado","value"=>ACTIVO, "operator"=>"=")
            ))["imagenelemento_array"];

            $obj->archivosElemento = Archivoelemento::getByFields(array(
                array("field"=>"elemento_id","value"=>$obj->elemento_id, "operator"=>"="),
                array("field"=>"archivoelemento_estado","value"=>ACTIVO, "operator"=>"=")
            ))["archivoelemento_array"];

            $datos = $obj;
        }else{
            $tipo = ERROR;
        }

        //Validacion de logueo
        $obj->elementoPerteneceAUsuario = false;
        $security = new Security(false);
        if($security->isLogged()){
            if(isset($_SESSION["cliente_id"]) && $_SESSION["cliente_id"] == $obj->getCliente_id()){
                $obj->elementoPerteneceAUsuario = true;
            }
        }

        $data["tipo"] = $tipo;
        $data["datos"] = $datos;
        return $data;

    }
    
    function enviarCorreoSolicitudElemento($objRecibido){

        $data = array();
        $tipo = SUCCESS;
        $datos = null;

        $obj = new Elemento(get_object_vars($objRecibido->elemento));
        
        if($obj){
            $datosCliente = new stdClass();
            $datosCliente->nombresCompletos = $objRecibido->nombresCompletos;;
            $datosCliente->numeroTelefono = $objRecibido->numeroTelefono;
            $datosCliente->correoElectronico = $objRecibido->correoElectronico;
            $datosCliente->observacion = $objRecibido->observacion;
            
            Utility::enviarCorreoSolicitud($obj,$datosCliente,"jpsantillangarcia@gmail.com");

        }else{
            $tipo = ERROR;
        }


        $data["tipo"] = $tipo;
        $data["datos"] = $datos;
        return $data;
	    
    }

}
?>