<?php
class SubtipoController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$subtipo_array = Subtipo::getList();
		$datos = $subtipo_array["subtipo_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($subtipo) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$subtipo = new Subtipo($subtipo);
            $subtipo->setSubtipo_fecharegistro(Utility::getFechaActual());
            $subtipo->setSubtipo_estado(ACTIVO);
			$resultado= $subtipo->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$subtipo){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$subtipoObj = new Subtipo($subtipo);
			$subtipoObj->setSubtipo_id($id);
			$resultado=$subtipoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Subtipo::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$subtipoObj = Subtipo::getById($id);
			$subtipoObj->setSubtipo_estado(INACTIVO);
			$resultado=$subtipoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getSubtipoListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$subtipo_array = Subtipo::getList(array(),(($pagina - 1) * $registros),$registros);
		$subtipo_array = $subtipo_array["subtipo_array"];
		foreach ($subtipo_array as $subtipo){
            $subtipo->tipo = Tipo::getById($subtipo->tipo_id);
        }
		$array_data["subtipoList"] = $subtipo_array;
		$array_data["subtipoCount"] = Subtipo::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>