<?php

class Security
{
    public static $randomAccessReferenceMap;
    private $isLogged = false;

    public function __construct($isRest)
    {
        if (isset($_GET["token"])) {
        } else if (!isset($_SESSION["cliente_id"])) {
            if ($isRest) {
                exit(json_encode(array("tipo" => 401)));
            } else {
                $this->isLogged = false;
            }
        } else {
            $this->isLogged = true;
        }
    }

    public function isLogged()
    {
        return $this->isLogged;
    }

    public static function canWrite($modulo_id)
    {
    }

    public static function setSession($nombre, $valor)
    {
        if (isset($_SESSION[$nombre])) {
            $_SESSION[$nombre] = $valor;
        } else {
            $_SESSION[$nombre] = $valor;
        }
    }

    public static function logout()
    {
        session_destroy();
    }

    public static function getSession($nombre)
    {
        if (isset($_SESSION[$nombre])) {
            return $_SESSION[$nombre];
        } else {
            return false;
        }
    }

    public static function encrypt($object)
    {
        $indirectReference = Security::$randomAccessReferenceMap->getIndirectReference($object);
        if ($indirectReference == null) {
            $indirectReference = Security::$randomAccessReferenceMap->addDirectReference($object);
            return (String)$indirectReference;
        }
        return (String)$indirectReference;
    }

    public static function decrypt($object)
    {
        return Security::$randomAccessReferenceMap->getDirectReference((String)$object);
    }

    public static function getCurrentClientId()
    {
        if (isset($_SESSION["cliente_id"])) {
            return $_SESSION["cliente_id"];
        } else {
            return "";
        }
    }

    public static function getCurrentUser()
    {
        $objUsuario = Usuario::getById(Security::getCurrentClientId());
        if ($objUsuario) {
            return $objUsuario;
        } else {
            return "";
        }
    }

    public static function getCurrentUsername()
    {
        $objUsuario = Cliente::getById(Security::getCurrentClientId());
        if ($objUsuario) {
            return $objUsuario->getCliente_usuario();
        } else {
            return "";
        }
    }


    public static function loguearCliente($username, $password)
    {
        $cliente = Cliente::getByFields(array(array("field" => "cliente_usuario", "operator" => "=", "conditional" => "AND", "value" => $username),
            array("field" => "cliente_clave", "operator" => "=", "conditional" => "AND", "value" => $password),
            array("field" => "cliente_estado", "operator" => "=", "conditional" => "AND", "value" => 1)
        ));
        $cliente_array = $cliente["cliente_array"];
        if (sizeof($cliente_array) > 0) {
            $clienteObj = $cliente_array[0];
            return $clienteObj;
        } else {
            return new Cliente();
        }
    }
}

?>
