<?php
class ArchivoelementoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $archivoelemento_id;
	public $elemento_id;
	public $archivoelemento_estadodoc;
	public $archivoelemento_estado;
	public $archivoelemento_url;
	public $archivoelemento_fechavencimiento;
	public $archivoelemento_tipo;

	public function setArchivoelemento_id($archivoelemento_id){
		$this->archivoelemento_id = $archivoelemento_id;
	}
	public function getArchivoelemento_id(){
		return $this->archivoelemento_id;
	}

	public function setElemento_id($elemento_id){
		$this->elemento_id = $elemento_id;
	}
	public function getElemento_id(){
		return $this->elemento_id;
	}

	public function setArchivoelemento_estadodoc($archivoelemento_estadodoc){
		$this->archivoelemento_estadodoc = $archivoelemento_estadodoc;
	}
	public function getArchivoelemento_estadodoc(){
		return $this->archivoelemento_estadodoc;
	}

	public function setArchivoelemento_estado($archivoelemento_estado){
		$this->archivoelemento_estado = $archivoelemento_estado;
	}
	public function getArchivoelemento_estado(){
		return $this->archivoelemento_estado;
	}

	public function setArchivoelemento_url($archivoelemento_url){
		$this->archivoelemento_url = $archivoelemento_url;
	}
	public function getArchivoelemento_url(){
		return $this->archivoelemento_url;
	}

	public function setArchivoelemento_fechavencimiento($archivoelemento_fechavencimiento){
		$this->archivoelemento_fechavencimiento = $archivoelemento_fechavencimiento;
	}
	public function getArchivoelemento_fechavencimiento(){
		return $this->archivoelemento_fechavencimiento;
	}

	public function setArchivoelemento_tipo($archivoelemento_tipo){
		$this->archivoelemento_tipo = $archivoelemento_tipo;
	}
	public function getArchivoelemento_tipo(){
		return $this->archivoelemento_tipo;
	}

	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->elemento_id))
				$query.="elemento_id, ";
			if(isset($this->archivoelemento_estadodoc))
				$query.="archivoelemento_estadodoc, ";
			if(isset($this->archivoelemento_estado))
				$query.="archivoelemento_estado, ";
			if(isset($this->archivoelemento_url))
				$query.="archivoelemento_url, ";
			if(isset($this->archivoelemento_fechavencimiento))
				$query.="archivoelemento_fechavencimiento, ";
			if(isset($this->archivoelemento_tipo))
				$query.="archivoelemento_tipo, ";
			if(isset($this->elemento_id))
				$query2.=":elemento_id, ";
			if(isset($this->archivoelemento_estadodoc))
				$query2.=":archivoelemento_estadodoc, ";
			if(isset($this->archivoelemento_estado))
				$query2.=":archivoelemento_estado, ";
			if(isset($this->archivoelemento_url))
				$query2.=":archivoelemento_url, ";
			if(isset($this->archivoelemento_fechavencimiento))
				$query2.=":archivoelemento_fechavencimiento, ";
			if(isset($this->archivoelemento_tipo))
				$query2.=":archivoelemento_tipo, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO archivoelemento(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->elemento_id))
				$stmt->bindParam(":elemento_id", $this->elemento_id,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_estadodoc))
				$stmt->bindParam(":archivoelemento_estadodoc", $this->archivoelemento_estadodoc,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_estado))
				$stmt->bindParam(":archivoelemento_estado", $this->archivoelemento_estado,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_url))
				$stmt->bindParam(":archivoelemento_url", $this->archivoelemento_url,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_fechavencimiento))
				$stmt->bindParam(":archivoelemento_fechavencimiento", $this->archivoelemento_fechavencimiento,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_tipo))
				$stmt->bindParam(":archivoelemento_tipo", $this->archivoelemento_tipo,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE archivoelemento SET ";
			if(isset($this->elemento_id))
				$query.="elemento_id=:elemento_id, ";
			if(isset($this->archivoelemento_estadodoc))
				$query.="archivoelemento_estadodoc=:archivoelemento_estadodoc, ";
			if(isset($this->archivoelemento_estado))
				$query.="archivoelemento_estado=:archivoelemento_estado, ";
			if(isset($this->archivoelemento_url))
				$query.="archivoelemento_url=:archivoelemento_url, ";
			if(isset($this->archivoelemento_fechavencimiento))
				$query.="archivoelemento_fechavencimiento=:archivoelemento_fechavencimiento, ";
			if(isset($this->archivoelemento_tipo))
				$query.="archivoelemento_tipo=:archivoelemento_tipo, ";
			if($query!="UPDATE archivoelemento SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE archivoelemento_id=:archivoelemento_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":archivoelemento_id", $this->archivoelemento_id,	PDO::PARAM_STR);
			if(isset($this->elemento_id))
				$stmt->bindParam(":elemento_id",	$this->elemento_id,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_estadodoc))
				$stmt->bindParam(":archivoelemento_estadodoc",	$this->archivoelemento_estadodoc,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_estado))
				$stmt->bindParam(":archivoelemento_estado",	$this->archivoelemento_estado,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_url))
				$stmt->bindParam(":archivoelemento_url",	$this->archivoelemento_url,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_fechavencimiento))
				$stmt->bindParam(":archivoelemento_fechavencimiento",	$this->archivoelemento_fechavencimiento,	PDO::PARAM_STR);
			if(isset($this->archivoelemento_tipo))
				$stmt->bindParam(":archivoelemento_tipo",	$this->archivoelemento_tipo,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM archivoelemento WHERE archivoelemento_id=:archivoelemento_id 
			LIMIT 1");
			$stmt->bindParam(":archivoelemento_id",	$this->archivoelemento_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($archivoelemento_id) {
		global $pdo;
		$sql = "SELECT * FROM archivoelemento WHERE archivoelemento_id=:archivoelemento_id AND archivoelemento_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":archivoelemento_id",$archivoelemento_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Archivoelemento($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return Utility::getByFields("Archivoelemento", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM archivoelemento WHERE archivoelemento_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}