<?php
class CampaniaEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $campania_id;
	public $campania_descripcion;
	public $campania_fechainicio;
	public $campania_fechafin;
	public $campania_fecharegistro;
	public $campania_estado;

	public function setCampania_id($campania_id){
		$this->campania_id = $campania_id;
	}
	public function getCampania_id(){
		return $this->campania_id;
	}

	public function setCampania_descripcion($campania_descripcion){
		$this->campania_descripcion = $campania_descripcion;
	}
	public function getCampania_descripcion(){
		return $this->campania_descripcion;
	}

	public function setCampania_fechainicio($campania_fechainicio){
		$this->campania_fechainicio = $campania_fechainicio;
	}
	public function getCampania_fechainicio(){
		return $this->campania_fechainicio;
	}

	public function setCampania_fechafin($campania_fechafin){
		$this->campania_fechafin = $campania_fechafin;
	}
	public function getCampania_fechafin(){
		return $this->campania_fechafin;
	}

	public function setCampania_fecharegistro($campania_fecharegistro){
		$this->campania_fecharegistro = $campania_fecharegistro;
	}
	public function getCampania_fecharegistro(){
		return $this->campania_fecharegistro;
	}

	public function setCampania_estado($campania_estado){
		$this->campania_estado = $campania_estado;
	}
	public function getCampania_estado(){
		return $this->campania_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->campania_descripcion))
				$query.="campania_descripcion, ";
			if(isset($this->campania_fechainicio))
				$query.="campania_fechainicio, ";
			if(isset($this->campania_fechafin))
				$query.="campania_fechafin, ";
			if(isset($this->campania_fecharegistro))
				$query.="campania_fecharegistro, ";
			if(isset($this->campania_estado))
				$query.="campania_estado, ";
			if(isset($this->campania_descripcion))
				$query2.=":campania_descripcion, ";
			if(isset($this->campania_fechainicio))
				$query2.=":campania_fechainicio, ";
			if(isset($this->campania_fechafin))
				$query2.=":campania_fechafin, ";
			if(isset($this->campania_fecharegistro))
				$query2.=":campania_fecharegistro, ";
			if(isset($this->campania_estado))
				$query2.=":campania_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO campania(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->campania_descripcion))
				$stmt->bindParam(":campania_descripcion", $this->campania_descripcion,	PDO::PARAM_STR);
			if(isset($this->campania_fechainicio))
				$stmt->bindParam(":campania_fechainicio", $this->campania_fechainicio,	PDO::PARAM_STR);
			if(isset($this->campania_fechafin))
				$stmt->bindParam(":campania_fechafin", $this->campania_fechafin,	PDO::PARAM_STR);
			if(isset($this->campania_fecharegistro))
				$stmt->bindParam(":campania_fecharegistro", $this->campania_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->campania_estado))
				$stmt->bindParam(":campania_estado", $this->campania_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE campania SET ";
			if(isset($this->campania_descripcion))
				$query.="campania_descripcion=:campania_descripcion, ";
			if(isset($this->campania_fechainicio))
				$query.="campania_fechainicio=:campania_fechainicio, ";
			if(isset($this->campania_fechafin))
				$query.="campania_fechafin=:campania_fechafin, ";
			if(isset($this->campania_fecharegistro))
				$query.="campania_fecharegistro=:campania_fecharegistro, ";
			if(isset($this->campania_estado))
				$query.="campania_estado=:campania_estado, ";
			if($query!="UPDATE campania SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE campania_id=:campania_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":campania_id", $this->campania_id,	PDO::PARAM_STR);
			if(isset($this->campania_descripcion))
				$stmt->bindParam(":campania_descripcion",	$this->campania_descripcion,	PDO::PARAM_STR);
			if(isset($this->campania_fechainicio))
				$stmt->bindParam(":campania_fechainicio",	$this->campania_fechainicio,	PDO::PARAM_STR);
			if(isset($this->campania_fechafin))
				$stmt->bindParam(":campania_fechafin",	$this->campania_fechafin,	PDO::PARAM_STR);
			if(isset($this->campania_fecharegistro))
				$stmt->bindParam(":campania_fecharegistro",	$this->campania_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->campania_estado))
				$stmt->bindParam(":campania_estado",	$this->campania_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM campania WHERE campania_id=:campania_id 
			LIMIT 1");
			$stmt->bindParam(":campania_id",	$this->campania_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($campania_id) {
		global $pdo;
		$sql = "SELECT * FROM campania WHERE campania_id=:campania_id AND campania_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":campania_id",$campania_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Campania($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "campania_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Campania", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM campania WHERE campania_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}