<?php
class DepartamentoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $departamento_id;
	public $departamento_departamento;
	public $pais_id;

	public function setDepartamento_id($departamento_id){
		$this->departamento_id = $departamento_id;
	}
	public function getDepartamento_id(){
		return $this->departamento_id;
	}

	public function setDepartamento_departamento($departamento_departamento){
		$this->departamento_departamento = $departamento_departamento;
	}
	public function getDepartamento_departamento(){
		return $this->departamento_departamento;
	}

	public function setPais_id($pais_id){
		$this->pais_id = $pais_id;
	}
	public function getPais_id(){
		return $this->pais_id;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->departamento_departamento))
				$query.="departamento_departamento, ";
			if(isset($this->pais_id))
				$query.="pais_id, ";
			if(isset($this->departamento_departamento))
				$query2.=":departamento_departamento, ";
			if(isset($this->pais_id))
				$query2.=":pais_id, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO departamento(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->departamento_departamento))
				$stmt->bindParam(":departamento_departamento", $this->departamento_departamento,	PDO::PARAM_STR);
			if(isset($this->pais_id))
				$stmt->bindParam(":pais_id", $this->pais_id,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE departamento SET ";
			if(isset($this->departamento_departamento))
				$query.="departamento_departamento=:departamento_departamento, ";
			if(isset($this->pais_id))
				$query.="pais_id=:pais_id, ";
			if($query!="UPDATE departamento SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE departamento_id=:departamento_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":departamento_id", $this->departamento_id,	PDO::PARAM_STR);
			if(isset($this->departamento_departamento))
				$stmt->bindParam(":departamento_departamento",	$this->departamento_departamento,	PDO::PARAM_STR);
			if(isset($this->pais_id))
				$stmt->bindParam(":pais_id",	$this->pais_id,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM departamento WHERE departamento_id=:departamento_id 
			LIMIT 1");
			$stmt->bindParam(":departamento_id",	$this->departamento_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($departamento_id) {
		global $pdo;
		$sql = "SELECT * FROM departamento WHERE departamento_id=:departamento_id AND pais_id != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":departamento_id",$departamento_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Departamento($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams = array();
		return Utility::getByFields("Departamento", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM departamento WHERE pais_id != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}