<?php
class DistritoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $distrito_id;
	public $distrito_distrito;
	public $provincia_id;

	public function setDistrito_id($distrito_id){
		$this->distrito_id = $distrito_id;
	}
	public function getDistrito_id(){
		return $this->distrito_id;
	}

	public function setDistrito_distrito($distrito_distrito){
		$this->distrito_distrito = $distrito_distrito;
	}
	public function getDistrito_distrito(){
		return $this->distrito_distrito;
	}

	public function setProvincia_id($provincia_id){
		$this->provincia_id = $provincia_id;
	}
	public function getProvincia_id(){
		return $this->provincia_id;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->distrito_distrito))
				$query.="distrito_distrito, ";
			if(isset($this->provincia_id))
				$query.="provincia_id, ";
			if(isset($this->distrito_distrito))
				$query2.=":distrito_distrito, ";
			if(isset($this->provincia_id))
				$query2.=":provincia_id, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO distrito(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->distrito_distrito))
				$stmt->bindParam(":distrito_distrito", $this->distrito_distrito,	PDO::PARAM_STR);
			if(isset($this->provincia_id))
				$stmt->bindParam(":provincia_id", $this->provincia_id,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE distrito SET ";
			if(isset($this->distrito_distrito))
				$query.="distrito_distrito=:distrito_distrito, ";
			if(isset($this->provincia_id))
				$query.="provincia_id=:provincia_id, ";
			if($query!="UPDATE distrito SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE distrito_id=:distrito_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":distrito_id", $this->distrito_id,	PDO::PARAM_STR);
			if(isset($this->distrito_distrito))
				$stmt->bindParam(":distrito_distrito",	$this->distrito_distrito,	PDO::PARAM_STR);
			if(isset($this->provincia_id))
				$stmt->bindParam(":provincia_id",	$this->provincia_id,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM distrito WHERE distrito_id=:distrito_id 
			LIMIT 1");
			$stmt->bindParam(":distrito_id",	$this->distrito_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($distrito_id) {
		global $pdo;
		$sql = "SELECT * FROM distrito WHERE distrito_id=:distrito_id AND provincia_id != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":distrito_id",$distrito_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Distrito($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams = array();
		return Utility::getByFields("Distrito", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM distrito WHERE provincia_id != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}