<?php
class ImagenelementoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $imagenelemento_id;
	public $elemento_id;
	public $imagenelemento_url;
	public $imagenelemento_estado;
	public $imagenelemento_nombre;

	public function setImagenelemento_id($imagenelemento_id){
		$this->imagenelemento_id = $imagenelemento_id;
	}
	public function getImagenelemento_id(){
		return $this->imagenelemento_id;
	}

	public function setElemento_id($elemento_id){
		$this->elemento_id = $elemento_id;
	}
	public function getElemento_id(){
		return $this->elemento_id;
	}

	public function setImagenelemento_url($imagenelemento_url){
		$this->imagenelemento_url = $imagenelemento_url;
	}
	public function getImagenelemento_url(){
		return $this->imagenelemento_url;
	}

	public function setImagenelemento_estado($imagenelemento_estado){
		$this->imagenelemento_estado = $imagenelemento_estado;
	}
	public function getImagenelemento_estado(){
		return $this->imagenelemento_estado;
	}
    public function setImagenelemento_nombre($imagenelemento_nombre){
        $this->imagenelemento_nombre = $imagenelemento_nombre;
    }
    public function getImagenelemento_nombre(){
        return $this->imagenelemento_nombre;
    }
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->elemento_id))
				$query.="elemento_id, ";
			if(isset($this->imagenelemento_url))
				$query.="imagenelemento_url, ";
			if(isset($this->imagenelemento_estado))
				$query.="imagenelemento_estado, ";
			if(isset($this->imagenelemento_nombre))
				$query.="imagenelemento_nombre, ";
			if(isset($this->elemento_id))
				$query2.=":elemento_id, ";
			if(isset($this->imagenelemento_url))
				$query2.=":imagenelemento_url, ";
			if(isset($this->imagenelemento_estado))
				$query2.=":imagenelemento_estado, ";
			if(isset($this->imagenelemento_nombre))
				$query2.=":imagenelemento_nombre, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO imagenelemento(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->elemento_id))
				$stmt->bindParam(":elemento_id", $this->elemento_id,	PDO::PARAM_STR);
			if(isset($this->imagenelemento_url))
				$stmt->bindParam(":imagenelemento_url", $this->imagenelemento_url,	PDO::PARAM_STR);
			if(isset($this->imagenelemento_estado))
				$stmt->bindParam(":imagenelemento_estado", $this->imagenelemento_estado,	PDO::PARAM_STR);
			if(isset($this->imagenelemento_nombre))
				$stmt->bindParam(":imagenelemento_nombre", $this->imagenelemento_nombre,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE imagenelemento SET ";
			if(isset($this->elemento_id))
				$query.="elemento_id=:elemento_id, ";
			if(isset($this->imagenelemento_url))
				$query.="imagenelemento_url=:imagenelemento_url, ";
			if(isset($this->imagenelemento_estado))
				$query.="imagenelemento_estado=:imagenelemento_estado, ";
			if(isset($this->imagenelemento_nombre))
				$query.="imagenelemento_nombre=:imagenelemento_nombre, ";
			if($query!="UPDATE imagenelemento SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE imagenelemento_id=:imagenelemento_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":imagenelemento_id", $this->imagenelemento_id,	PDO::PARAM_STR);
			if(isset($this->elemento_id))
				$stmt->bindParam(":elemento_id",	$this->elemento_id,	PDO::PARAM_STR);
			if(isset($this->imagenelemento_url))
				$stmt->bindParam(":imagenelemento_url",	$this->imagenelemento_url,	PDO::PARAM_STR);
			if(isset($this->imagenelemento_estado))
				$stmt->bindParam(":imagenelemento_estado",	$this->imagenelemento_estado,	PDO::PARAM_STR);
            if(isset($this->imagenelemento_nombre))
				$stmt->bindParam(":imagenelemento_nombre",	$this->imagenelemento_nombre,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM imagenelemento WHERE imagenelemento_id=:imagenelemento_id 
			LIMIT 1");
			$stmt->bindParam(":imagenelemento_id",	$this->imagenelemento_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($imagenelemento_id) {
		global $pdo;
		$sql = "SELECT * FROM imagenelemento WHERE imagenelemento_id=:imagenelemento_id AND imagenelemento_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":imagenelemento_id",$imagenelemento_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Imagenelemento($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return Utility::getByFields("Imagenelemento", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM imagenelemento WHERE imagenelemento_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}