<?php
class PermisoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $permiso_id;
	public $permiso_descripcion;
	public $permiso_categoria;
	public $permiso_moduloid;
	public $permiso_modulofeature;
	public $permiso_modulopadre;
	public $permiso_moduloestado;
	public $permiso_modulo;

	public function setPermiso_id($permiso_id){
		$this->permiso_id = $permiso_id;
	}
	public function getPermiso_id(){
		return $this->permiso_id;
	}

	public function setPermiso_descripcion($permiso_descripcion){
		$this->permiso_descripcion = $permiso_descripcion;
	}
	public function getPermiso_descripcion(){
		return $this->permiso_descripcion;
	}

	public function setPermiso_categoria($permiso_categoria){
		$this->permiso_categoria = $permiso_categoria;
	}
	public function getPermiso_categoria(){
		return $this->permiso_categoria;
	}

	public function setPermiso_moduloid($permiso_moduloid){
		$this->permiso_moduloid = $permiso_moduloid;
	}
	public function getPermiso_moduloid(){
		return $this->permiso_moduloid;
	}

	public function setPermiso_modulofeature($permiso_modulofeature){
		$this->permiso_modulofeature = $permiso_modulofeature;
	}
	public function getPermiso_modulofeature(){
		return $this->permiso_modulofeature;
	}

	public function setPermiso_modulopadre($permiso_modulopadre){
		$this->permiso_modulopadre = $permiso_modulopadre;
	}
	public function getPermiso_modulopadre(){
		return $this->permiso_modulopadre;
	}

	public function setPermiso_moduloestado($permiso_moduloestado){
		$this->permiso_moduloestado = $permiso_moduloestado;
	}
	public function getPermiso_moduloestado(){
		return $this->permiso_moduloestado;
	}

	public function setPermiso_modulo($permiso_modulo){
		$this->permiso_modulo = $permiso_modulo;
	}
	public function getPermiso_modulo(){
		return $this->permiso_modulo;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->permiso_descripcion))
				$query.="permiso_descripcion, ";
			if(isset($this->permiso_categoria))
				$query.="permiso_categoria, ";
			if(isset($this->permiso_moduloid))
				$query.="permiso_moduloid, ";
			if(isset($this->permiso_modulofeature))
				$query.="permiso_modulofeature, ";
			if(isset($this->permiso_modulopadre))
				$query.="permiso_modulopadre, ";
			if(isset($this->permiso_moduloestado))
				$query.="permiso_moduloestado, ";
			if(isset($this->permiso_modulo))
				$query.="permiso_modulo, ";
			if(isset($this->permiso_descripcion))
				$query2.=":permiso_descripcion, ";
			if(isset($this->permiso_categoria))
				$query2.=":permiso_categoria, ";
			if(isset($this->permiso_moduloid))
				$query2.=":permiso_moduloid, ";
			if(isset($this->permiso_modulofeature))
				$query2.=":permiso_modulofeature, ";
			if(isset($this->permiso_modulopadre))
				$query2.=":permiso_modulopadre, ";
			if(isset($this->permiso_moduloestado))
				$query2.=":permiso_moduloestado, ";
			if(isset($this->permiso_modulo))
				$query2.=":permiso_modulo, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO permiso(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->permiso_descripcion))
				$stmt->bindParam(":permiso_descripcion", $this->permiso_descripcion,	PDO::PARAM_STR);
			if(isset($this->permiso_categoria))
				$stmt->bindParam(":permiso_categoria", $this->permiso_categoria,	PDO::PARAM_STR);
			if(isset($this->permiso_moduloid))
				$stmt->bindParam(":permiso_moduloid", $this->permiso_moduloid,	PDO::PARAM_STR);
			if(isset($this->permiso_modulofeature))
				$stmt->bindParam(":permiso_modulofeature", $this->permiso_modulofeature,	PDO::PARAM_STR);
			if(isset($this->permiso_modulopadre))
				$stmt->bindParam(":permiso_modulopadre", $this->permiso_modulopadre,	PDO::PARAM_STR);
			if(isset($this->permiso_moduloestado))
				$stmt->bindParam(":permiso_moduloestado", $this->permiso_moduloestado,	PDO::PARAM_STR);
			if(isset($this->permiso_modulo))
				$stmt->bindParam(":permiso_modulo", $this->permiso_modulo,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE permiso SET ";
			if(isset($this->permiso_descripcion))
				$query.="permiso_descripcion=:permiso_descripcion, ";
			if(isset($this->permiso_categoria))
				$query.="permiso_categoria=:permiso_categoria, ";
			if(isset($this->permiso_moduloid))
				$query.="permiso_moduloid=:permiso_moduloid, ";
			if(isset($this->permiso_modulofeature))
				$query.="permiso_modulofeature=:permiso_modulofeature, ";
			if(isset($this->permiso_modulopadre))
				$query.="permiso_modulopadre=:permiso_modulopadre, ";
			if(isset($this->permiso_moduloestado))
				$query.="permiso_moduloestado=:permiso_moduloestado, ";
			if(isset($this->permiso_modulo))
				$query.="permiso_modulo=:permiso_modulo, ";
			if($query!="UPDATE permiso SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE permiso_id=:permiso_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":permiso_id", $this->permiso_id,	PDO::PARAM_STR);
			if(isset($this->permiso_descripcion))
				$stmt->bindParam(":permiso_descripcion",	$this->permiso_descripcion,	PDO::PARAM_STR);
			if(isset($this->permiso_categoria))
				$stmt->bindParam(":permiso_categoria",	$this->permiso_categoria,	PDO::PARAM_STR);
			if(isset($this->permiso_moduloid))
				$stmt->bindParam(":permiso_moduloid",	$this->permiso_moduloid,	PDO::PARAM_STR);
			if(isset($this->permiso_modulofeature))
				$stmt->bindParam(":permiso_modulofeature",	$this->permiso_modulofeature,	PDO::PARAM_STR);
			if(isset($this->permiso_modulopadre))
				$stmt->bindParam(":permiso_modulopadre",	$this->permiso_modulopadre,	PDO::PARAM_STR);
			if(isset($this->permiso_moduloestado))
				$stmt->bindParam(":permiso_moduloestado",	$this->permiso_moduloestado,	PDO::PARAM_STR);
			if(isset($this->permiso_modulo))
				$stmt->bindParam(":permiso_modulo",	$this->permiso_modulo,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM permiso WHERE permiso_id=:permiso_id 
			LIMIT 1");
			$stmt->bindParam(":permiso_id",	$this->permiso_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($permiso_id) {
		global $pdo;
		$sql = "SELECT * FROM permiso WHERE permiso_id=:permiso_id AND permiso_modulo != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":permiso_id",$permiso_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Permiso($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams = array();
		return Utility::getByFields("Permiso", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM permiso WHERE permiso_modulo != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}