<?php
class ProvinciaEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $provincia_id;
	public $provincia_provincia;
	public $departamento_id;

	public function setProvincia_id($provincia_id){
		$this->provincia_id = $provincia_id;
	}
	public function getProvincia_id(){
		return $this->provincia_id;
	}

	public function setProvincia_provincia($provincia_provincia){
		$this->provincia_provincia = $provincia_provincia;
	}
	public function getProvincia_provincia(){
		return $this->provincia_provincia;
	}

	public function setDepartamento_id($departamento_id){
		$this->departamento_id = $departamento_id;
	}
	public function getDepartamento_id(){
		return $this->departamento_id;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->provincia_provincia))
				$query.="provincia_provincia, ";
			if(isset($this->departamento_id))
				$query.="departamento_id, ";
			if(isset($this->provincia_provincia))
				$query2.=":provincia_provincia, ";
			if(isset($this->departamento_id))
				$query2.=":departamento_id, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO provincia(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->provincia_provincia))
				$stmt->bindParam(":provincia_provincia", $this->provincia_provincia,	PDO::PARAM_STR);
			if(isset($this->departamento_id))
				$stmt->bindParam(":departamento_id", $this->departamento_id,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE provincia SET ";
			if(isset($this->provincia_provincia))
				$query.="provincia_provincia=:provincia_provincia, ";
			if(isset($this->departamento_id))
				$query.="departamento_id=:departamento_id, ";
			if($query!="UPDATE provincia SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE provincia_id=:provincia_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":provincia_id", $this->provincia_id,	PDO::PARAM_STR);
			if(isset($this->provincia_provincia))
				$stmt->bindParam(":provincia_provincia",	$this->provincia_provincia,	PDO::PARAM_STR);
			if(isset($this->departamento_id))
				$stmt->bindParam(":departamento_id",	$this->departamento_id,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM provincia WHERE provincia_id=:provincia_id 
			LIMIT 1");
			$stmt->bindParam(":provincia_id",	$this->provincia_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($provincia_id) {
		global $pdo;
		$sql = "SELECT * FROM provincia WHERE provincia_id=:provincia_id AND departamento_id != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":provincia_id",$provincia_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Provincia($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams = array();
		return Utility::getByFields("Provincia", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM provincia WHERE departamento_id != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}