<?php
class TipoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $tipo_id;
	public $tipo_descripcion;
	public $tipo_fecharegistro;
	public $tipo_estado;

	public function setTipo_id($tipo_id){
		$this->tipo_id = $tipo_id;
	}
	public function getTipo_id(){
		return $this->tipo_id;
	}

	public function setTipo_descripcion($tipo_descripcion){
		$this->tipo_descripcion = $tipo_descripcion;
	}
	public function getTipo_descripcion(){
		return $this->tipo_descripcion;
	}

	public function setTipo_fecharegistro($tipo_fecharegistro){
		$this->tipo_fecharegistro = $tipo_fecharegistro;
	}
	public function getTipo_fecharegistro(){
		return $this->tipo_fecharegistro;
	}

	public function setTipo_estado($tipo_estado){
		$this->tipo_estado = $tipo_estado;
	}
	public function getTipo_estado(){
		return $this->tipo_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->tipo_descripcion))
				$query.="tipo_descripcion, ";
			if(isset($this->tipo_fecharegistro))
				$query.="tipo_fecharegistro, ";
			if(isset($this->tipo_estado))
				$query.="tipo_estado, ";
			if(isset($this->tipo_descripcion))
				$query2.=":tipo_descripcion, ";
			if(isset($this->tipo_fecharegistro))
				$query2.=":tipo_fecharegistro, ";
			if(isset($this->tipo_estado))
				$query2.=":tipo_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO tipo(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->tipo_descripcion))
				$stmt->bindParam(":tipo_descripcion", $this->tipo_descripcion,	PDO::PARAM_STR);
			if(isset($this->tipo_fecharegistro))
				$stmt->bindParam(":tipo_fecharegistro", $this->tipo_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->tipo_estado))
				$stmt->bindParam(":tipo_estado", $this->tipo_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE tipo SET ";
			if(isset($this->tipo_descripcion))
				$query.="tipo_descripcion=:tipo_descripcion, ";
			if(isset($this->tipo_fecharegistro))
				$query.="tipo_fecharegistro=:tipo_fecharegistro, ";
			if(isset($this->tipo_estado))
				$query.="tipo_estado=:tipo_estado, ";
			if($query!="UPDATE tipo SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE tipo_id=:tipo_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":tipo_id", $this->tipo_id,	PDO::PARAM_STR);
			if(isset($this->tipo_descripcion))
				$stmt->bindParam(":tipo_descripcion",	$this->tipo_descripcion,	PDO::PARAM_STR);
			if(isset($this->tipo_fecharegistro))
				$stmt->bindParam(":tipo_fecharegistro",	$this->tipo_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->tipo_estado))
				$stmt->bindParam(":tipo_estado",	$this->tipo_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM tipo WHERE tipo_id=:tipo_id 
			LIMIT 1");
			$stmt->bindParam(":tipo_id",	$this->tipo_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($tipo_id) {
		global $pdo;
		$sql = "SELECT * FROM tipo WHERE tipo_id=:tipo_id AND tipo_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":tipo_id",$tipo_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Tipo($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "tipo_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Tipo", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM tipo WHERE tipo_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}