<?php
class TipoarchivoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $tipoarchivo_id;
	public $tipoarchivo_descripcion;
	public $tipoarchivo_tipo;
	public $tipoarchivo_estado;

	public function setTipoarchivo_id($tipoarchivo_id){
		$this->tipoarchivo_id = $tipoarchivo_id;
	}
	public function getTipoarchivo_id(){
		return $this->tipoarchivo_id;
	}

	public function setTipoarchivo_descripcion($tipoarchivo_descripcion){
		$this->tipoarchivo_descripcion = $tipoarchivo_descripcion;
	}
	public function getTipoarchivo_descripcion(){
		return $this->tipoarchivo_descripcion;
	}

	public function setTipoarchivo_tipo($tipoarchivo_tipo){
		$this->tipoarchivo_tipo = $tipoarchivo_tipo;
	}
	public function getTipoarchivo_tipo(){
		return $this->tipoarchivo_tipo;
	}

	public function setTipoarchivo_estado($tipoarchivo_estado){
		$this->tipoarchivo_estado = $tipoarchivo_estado;
	}
	public function getTipoarchivo_estado(){
		return $this->tipoarchivo_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->tipoarchivo_descripcion))
				$query.="tipoarchivo_descripcion, ";
			if(isset($this->tipoarchivo_tipo))
				$query.="tipoarchivo_tipo, ";
			if(isset($this->tipoarchivo_estado))
				$query.="tipoarchivo_estado, ";
			if(isset($this->tipoarchivo_descripcion))
				$query2.=":tipoarchivo_descripcion, ";
			if(isset($this->tipoarchivo_tipo))
				$query2.=":tipoarchivo_tipo, ";
			if(isset($this->tipoarchivo_estado))
				$query2.=":tipoarchivo_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO tipoarchivo(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->tipoarchivo_descripcion))
				$stmt->bindParam(":tipoarchivo_descripcion", $this->tipoarchivo_descripcion,	PDO::PARAM_STR);
			if(isset($this->tipoarchivo_tipo))
				$stmt->bindParam(":tipoarchivo_tipo", $this->tipoarchivo_tipo,	PDO::PARAM_STR);
			if(isset($this->tipoarchivo_estado))
				$stmt->bindParam(":tipoarchivo_estado", $this->tipoarchivo_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE tipoarchivo SET ";
			if(isset($this->tipoarchivo_descripcion))
				$query.="tipoarchivo_descripcion=:tipoarchivo_descripcion, ";
			if(isset($this->tipoarchivo_tipo))
				$query.="tipoarchivo_tipo=:tipoarchivo_tipo, ";
			if(isset($this->tipoarchivo_estado))
				$query.="tipoarchivo_estado=:tipoarchivo_estado, ";
			if($query!="UPDATE tipoarchivo SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE tipoarchivo_id=:tipoarchivo_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":tipoarchivo_id", $this->tipoarchivo_id,	PDO::PARAM_STR);
			if(isset($this->tipoarchivo_descripcion))
				$stmt->bindParam(":tipoarchivo_descripcion",	$this->tipoarchivo_descripcion,	PDO::PARAM_STR);
			if(isset($this->tipoarchivo_tipo))
				$stmt->bindParam(":tipoarchivo_tipo",	$this->tipoarchivo_tipo,	PDO::PARAM_STR);
			if(isset($this->tipoarchivo_estado))
				$stmt->bindParam(":tipoarchivo_estado",	$this->tipoarchivo_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM tipoarchivo WHERE tipoarchivo_id=:tipoarchivo_id 
			LIMIT 1");
			$stmt->bindParam(":tipoarchivo_id",	$this->tipoarchivo_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($tipoarchivo_id) {
		global $pdo;
		$sql = "SELECT * FROM tipoarchivo WHERE tipoarchivo_id=:tipoarchivo_id AND tipoarchivo_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":tipoarchivo_id",$tipoarchivo_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Tipoarchivo($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "tipoarchivo_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Tipoarchivo", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM tipoarchivo WHERE tipoarchivo_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}