<?php
class Elemento extends ElementoEntity{

    public static function obtenerListaElementosConFiltros($distrito,$subtipo,$estado){

        global $pdo;
        $array_salida = array();

        $sqlWhere = "";

        if($distrito != TODOS && $estado != TODOS){
            $sqlWhere .= " and distrito_id='".$distrito ."' ";
        }

        if($subtipo != TODOS && $estado != TODOS){
            $sqlWhere .= " and subtipo_id='".$subtipo ."' ";
        }

        if($estado != TODOS){
            $sqlWhere .= " and elemento_estado='". $estado ."' ";
        }

        $sql = "select * from elemento where elemento_estavencido='0' " . $sqlWhere;

        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $stmt->setFetchMode(PDO::FETCH_CLASS, 'ElementoEntity');
        $elemento = array();
        while ($elemento = $stmt->fetch()) {
            $array_salida[] = $elemento;
        }

        return $array_salida;

    }

    /**
     * MÉTODO OPTIMIZADO: Correlated Subqueries
     * Soluciona error 1055 (only_full_group_by) y calcula vencimiento en tiempo real
     * Sin UPDATEs en queries GET (Bug Fix)
     */
    public static function obtenerListaElementosOptimizado($distrito, $subtipo, $estado){
        global $pdo;
        $array_salida = array();

        $sqlWhere = "";

        if($distrito != TODOS){
            $sqlWhere .= " AND e.distrito_id='" . $distrito . "' ";
        }

        if($subtipo != TODOS){
            $sqlWhere .= " AND e.subtipo_id='" . $subtipo . "' ";
        }

        if($estado != TODOS){
            $sqlWhere .= " AND e.elemento_estado='" . $estado . "' ";
        }

        // Query optimizada: Usamos subqueries en el SELECT para evitar problemas de GROUP BY
        // y calcular el vencimiento al vuelo de forma compatible con SQL estricto.
        $sql = "SELECT 
                    e.*,
                    s.subtipo_id as s_subtipo_id,
                    s.subtipo_descripcion,
                    s.subtipo_estado,
                    s.tipo_id as s_tipo_id,
                    d.distrito_id as d_distrito_id,
                    d.distrito_distrito,
                    d.provincia_id as d_provincia_id,
                    
                    /* CÁLCULO DE VENCIMIENTO usando Subquery (180 dias aprox) */
                    CASE 
                        WHEN EXISTS (
                            SELECT 1
                            FROM archivoelemento ae
                            WHERE ae.elemento_id = e.elemento_id
                            AND ae.archivoelemento_tipo IN ('" . CONTRATO . "', '" . LICENCIA . "')
                            AND ae.archivoelemento_estado = '" . ACTIVO . "'
                            AND ae.archivoelemento_fechavencimiento <= DATE_ADD(CURRENT_DATE(), INTERVAL 180 DAY)
                        ) THEN 1
                        ELSE 0
                    END as calculado_estavencido

                FROM elemento e
                LEFT JOIN subtipo s ON e.subtipo_id = s.subtipo_id
                LEFT JOIN distrito d ON e.distrito_id = d.distrito_id
                WHERE 1=1 " . $sqlWhere;

        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($rows as $row) {
            $elemento = new ElementoEntity();
            
            // Mapear campos del elemento
            foreach ($row as $key => $value) {
                if (strpos($key, 's_') !== 0 && strpos($key, 'd_') !== 0 && 
                    !in_array($key, ['subtipo_descripcion', 'subtipo_estado', 'distrito_distrito', 'calculado_estavencido'])) {
                    if (property_exists($elemento, $key)) {
                        $elemento->$key = $value;
                    }
                }
            }

            // SOBREESCRIBIR el estado con el cálculo en tiempo real
            if (isset($row['calculado_estavencido'])) {
                $elemento->elemento_estavencido = $row['calculado_estavencido'];
            }

            // Crear objeto subtipo
            $elemento->subtipo = new stdClass();
            $elemento->subtipo->subtipo_id = $row['s_subtipo_id'];
            $elemento->subtipo->subtipo_descripcion = $row['subtipo_descripcion'];
            $elemento->subtipo->subtipo_estado = $row['subtipo_estado'];
            $elemento->subtipo->tipo_id = $row['s_tipo_id'];

            // Crear objeto distrito
            $elemento->distrito = new stdClass();
            $elemento->distrito->distrito_id = $row['d_distrito_id'];
            $elemento->distrito->distrito_distrito = $row['distrito_distrito'];
            $elemento->distrito->provincia_id = $row['d_provincia_id'];

            $array_salida[] = $elemento;
        }

        return $array_salida;
    }

}
?>