<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/cliente/all","getClienteAll");
$app->get("/cliente/:id","getClienteById");
$app->post("/cliente","addCliente");
$app->put("/cliente/:id","updateCliente");
$app->delete("/cliente/:id", "deleteCliente");
$app->get("/paginado/:pagina/:registros", "getClienteListPaginado");

$app->run();

function getClienteAll() {
	$clienteCtrl = new ClienteController();
	echo json_encode($clienteCtrl->getAllData());
}
function getClienteById($id) {
	$clienteCtrl = new ClienteController();
	echo json_encode($clienteCtrl->getById($id));
}
function addCliente() {
	$request = \Slim\Slim::getInstance()->request();
	$cliente = json_decode($request->getBody());
	$clienteCtrl = new ClienteController();
	$array = get_object_vars($cliente);
	echo json_encode($clienteCtrl->add($array));
}
function updateCliente($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$cliente = json_decode($body);
	$cliente_vector = get_object_vars($cliente);
	$clienteCtrl = new ClienteController();
	echo json_encode($clienteCtrl->update($id,$cliente_vector));
}
function deleteCliente($id) {
	$clienteCtrl = new ClienteController();
	echo json_encode($clienteCtrl->delete($id));
}
function getClienteListPaginado($pagina,$registros){
	$clienteCtrl = new ClienteController();
	echo json_encode($clienteCtrl->getClienteListPaginado($pagina, $registros));
}

?>