<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/distrito/all","getDistritoAll");
$app->get("/distrito/:id","getDistritoById");
$app->post("/distrito","addDistrito");
$app->put("/distrito/:id","updateDistrito");
$app->delete("/distrito/:id", "deleteDistrito");
$app->get("/paginado/:pagina/:registros", "getDistritoListPaginado");

$app->run();

function getDistritoAll() {
	$distritoCtrl = new DistritoController();
	echo json_encode($distritoCtrl->getAllData());
}
function getDistritoById($id) {
	$distritoCtrl = new DistritoController();
	echo json_encode($distritoCtrl->getById($id));
}
function addDistrito() {
	$request = \Slim\Slim::getInstance()->request();
	$distrito = json_decode($request->getBody());
	$distritoCtrl = new DistritoController();
	$array = get_object_vars($distrito);
	echo json_encode($distritoCtrl->add($array));
}
function updateDistrito($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$distrito = json_decode($body);
	$distrito_vector = get_object_vars($distrito);
	$distritoCtrl = new DistritoController();
	echo json_encode($distritoCtrl->update($id,$distrito_vector));
}
function deleteDistrito($id) {
	$distritoCtrl = new DistritoController();
	echo json_encode($distritoCtrl->delete($id));
}
function getDistritoListPaginado($pagina,$registros){
	$distritoCtrl = new DistritoController();
	echo json_encode($distritoCtrl->getDistritoListPaginado($pagina, $registros));
}

?>