<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/imagenelemento/all","getImagenelementoAll");
$app->get("/imagenelemento/:id","getImagenelementoById");
$app->post("/imagenelemento","addImagenelemento");
$app->put("/imagenelemento/:id","updateImagenelemento");
$app->delete("/imagenelemento/:id", "deleteImagenelemento");
$app->get("/paginado/:pagina/:registros", "getImagenelementoListPaginado");

$app->run();

function getImagenelementoAll() {
	$imagenelementoCtrl = new ImagenelementoController();
	echo json_encode($imagenelementoCtrl->getAllData());
}
function getImagenelementoById($id) {
	$imagenelementoCtrl = new ImagenelementoController();
	echo json_encode($imagenelementoCtrl->getById($id));
}
function addImagenelemento() {
	$request = \Slim\Slim::getInstance()->request();
	$imagenelemento = json_decode($request->getBody());
	$imagenelementoCtrl = new ImagenelementoController();
	$array = get_object_vars($imagenelemento);
	echo json_encode($imagenelementoCtrl->add($array));
}
function updateImagenelemento($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$imagenelemento = json_decode($body);
	$imagenelemento_vector = get_object_vars($imagenelemento);
	$imagenelementoCtrl = new ImagenelementoController();
	echo json_encode($imagenelementoCtrl->update($id,$imagenelemento_vector));
}
function deleteImagenelemento($id) {
	$imagenelementoCtrl = new ImagenelementoController();
	echo json_encode($imagenelementoCtrl->delete($id));
}
function getImagenelementoListPaginado($pagina,$registros){
	$imagenelementoCtrl = new ImagenelementoController();
	echo json_encode($imagenelementoCtrl->getImagenelementoListPaginado($pagina, $registros));
}

?>