<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/pais/all","getPaisAll");
$app->get("/pais/:id","getPaisById");
$app->post("/pais","addPais");
$app->put("/pais/:id","updatePais");
$app->delete("/pais/:id", "deletePais");
$app->get("/paginado/:pagina/:registros", "getPaisListPaginado");
$app->get("/obtenerUbigeoPorPais", "obtenerUbigeoPorPais");

$app->run();

function getPaisAll() {
	$paisCtrl = new PaisController();
	echo json_encode($paisCtrl->getAllData());
}
function getPaisById($id) {
	$paisCtrl = new PaisController();
	echo json_encode($paisCtrl->getById($id));
}
function addPais() {
	$request = \Slim\Slim::getInstance()->request();
	$pais = json_decode($request->getBody());
	$paisCtrl = new PaisController();
	$array = get_object_vars($pais);
	echo json_encode($paisCtrl->add($array));
}
function updatePais($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$pais = json_decode($body);
	$pais_vector = get_object_vars($pais);
	$paisCtrl = new PaisController();
	echo json_encode($paisCtrl->update($id,$pais_vector));
}
function deletePais($id) {
	$paisCtrl = new PaisController();
	echo json_encode($paisCtrl->delete($id));
}
function getPaisListPaginado($pagina,$registros){
	$paisCtrl = new PaisController();
	echo json_encode($paisCtrl->getPaisListPaginado($pagina, $registros));
}

function obtenerUbigeoPorPais(){
    $paisCtrl = new PaisController();
    echo json_encode($paisCtrl->obtenerUbigeoPorPais());
}

?>