<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/permisousuario/all","getPermisousuarioAll");
$app->get("/permisousuario/:id","getPermisousuarioById");
$app->post("/permisousuario","addPermisousuario");
$app->put("/permisousuario/:id","updatePermisousuario");
$app->delete("/permisousuario/:id", "deletePermisousuario");
$app->get("/paginado/:pagina/:registros", "getPermisousuarioListPaginado");

$app->run();

function getPermisousuarioAll() {
	$permisousuarioCtrl = new PermisousuarioController();
	echo json_encode($permisousuarioCtrl->getAllData());
}
function getPermisousuarioById($id) {
	$permisousuarioCtrl = new PermisousuarioController();
	echo json_encode($permisousuarioCtrl->getById($id));
}
function addPermisousuario() {
	$request = \Slim\Slim::getInstance()->request();
	$permisousuario = json_decode($request->getBody());
	$permisousuarioCtrl = new PermisousuarioController();
	$array = get_object_vars($permisousuario);
	echo json_encode($permisousuarioCtrl->add($array));
}
function updatePermisousuario($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$permisousuario = json_decode($body);
	$permisousuario_vector = get_object_vars($permisousuario);
	$permisousuarioCtrl = new PermisousuarioController();
	echo json_encode($permisousuarioCtrl->update($id,$permisousuario_vector));
}
function deletePermisousuario($id) {
	$permisousuarioCtrl = new PermisousuarioController();
	echo json_encode($permisousuarioCtrl->delete($id));
}
function getPermisousuarioListPaginado($pagina,$registros){
	$permisousuarioCtrl = new PermisousuarioController();
	echo json_encode($permisousuarioCtrl->getPermisousuarioListPaginado($pagina, $registros));
}

?>