<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/tipoarchivo/all","getTipoarchivoAll");
$app->get("/tipoarchivo/:id","getTipoarchivoById");
$app->post("/tipoarchivo","addTipoarchivo");
$app->put("/tipoarchivo/:id","updateTipoarchivo");
$app->delete("/tipoarchivo/:id", "deleteTipoarchivo");
$app->get("/paginado/:pagina/:registros", "getTipoarchivoListPaginado");

$app->run();

function getTipoarchivoAll() {
	$tipoarchivoCtrl = new TipoarchivoController();
	echo json_encode($tipoarchivoCtrl->getAllData());
}
function getTipoarchivoById($id) {
	$tipoarchivoCtrl = new TipoarchivoController();
	echo json_encode($tipoarchivoCtrl->getById($id));
}
function addTipoarchivo() {
	$request = \Slim\Slim::getInstance()->request();
	$tipoarchivo = json_decode($request->getBody());
	$tipoarchivoCtrl = new TipoarchivoController();
	$array = get_object_vars($tipoarchivo);
	echo json_encode($tipoarchivoCtrl->add($array));
}
function updateTipoarchivo($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$tipoarchivo = json_decode($body);
	$tipoarchivo_vector = get_object_vars($tipoarchivo);
	$tipoarchivoCtrl = new TipoarchivoController();
	echo json_encode($tipoarchivoCtrl->update($id,$tipoarchivo_vector));
}
function deleteTipoarchivo($id) {
	$tipoarchivoCtrl = new TipoarchivoController();
	echo json_encode($tipoarchivoCtrl->delete($id));
}
function getTipoarchivoListPaginado($pagina,$registros){
	$tipoarchivoCtrl = new TipoarchivoController();
	echo json_encode($tipoarchivoCtrl->getTipoarchivoListPaginado($pagina, $registros));
}

?>