<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/usuario/all","getUsuarioAll");
$app->get("/usuario/:id","getUsuarioById");
$app->post("/usuario","addUsuario");
$app->put("/usuario/:id","updateUsuario");
$app->delete("/usuario/:id", "deleteUsuario");
$app->get("/paginado/:pagina/:registros", "getUsuarioListPaginado");

$app->run();

function getUsuarioAll() {
	$usuarioCtrl = new UsuarioController();
	echo json_encode($usuarioCtrl->getAllData());
}
function getUsuarioById($id) {
	$usuarioCtrl = new UsuarioController();
	echo json_encode($usuarioCtrl->getById($id));
}
function addUsuario() {
	$request = \Slim\Slim::getInstance()->request();
	$usuario = json_decode($request->getBody());
	$usuarioCtrl = new UsuarioController();
	$array = get_object_vars($usuario);
	echo json_encode($usuarioCtrl->add($array));
}
function updateUsuario($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$usuario = json_decode($body);
	$usuario_vector = get_object_vars($usuario);
	$usuarioCtrl = new UsuarioController();
	echo json_encode($usuarioCtrl->update($id,$usuario_vector));
}
function deleteUsuario($id) {
	$usuarioCtrl = new UsuarioController();
	echo json_encode($usuarioCtrl->delete($id));
}
function getUsuarioListPaginado($pagina,$registros){
	$usuarioCtrl = new UsuarioController();
	echo json_encode($usuarioCtrl->getUsuarioListPaginado($pagina, $registros));
}

?>