App.controller('elementoCtrl', ['$scope','$http','$timeout', function($scope,$http,$stateParams,$timeout){

    var pagina = 1;
    if (!(parseInt(pagina)>0))
        pagina = "1";
    var registros = "10";

    var map;
    var geox = -5.1778988;
    var geoy = -80.6555;
    $scope.elementoID = "";
    $scope.departamentoID = "";
    $scope.elemento = {};
    $scope.urlImagenes = "/publicidadpaneles/";
    $scope.myInterval = 3000;
    $scope.slides = [];
    $scope.images = [];
    $scope.archivosElemento = [];


    $scope.rutaAbsoluta = getAbsolutePath();

    $scope.getParameterByName = getParameterByName;
    $scope.descargar = descargar;
    $scope.enviarMensaje = enviarMensaje;
    $scope.descargarPDF = descargarPDF;

    /**
     * @param String name
     * @return String
     */
    function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search);
        return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    }

    function descargar(archivosElemento) {

        if(archivosElemento){

            var url = $scope.rutaAbsoluta+"publicidadpaneles/"+archivosElemento.archivoelemento_url;
            window.open(url);

        }

    }

    function _init() {

        $scope.elementoID = $scope.getParameterByName('elementoID');
        $scope.departamentoID = $scope.getParameterByName('departamentoID');

        if($scope.elementoID*1>0){
            $http.get('backend/rest/elemento/elemento/obtenerElementoParaWeb/'+$scope.elementoID).success(function (response){

                if (response.tipo == 1) {

                    $scope.elemento = response.datos;
                    $scope.archivosElemento = $scope.elemento.archivosElemento;
                    $scope.elementoPerteneceAUsuario = $scope.elemento.elementoPerteneceAUsuario;

                    angular.forEach($scope.elemento.listaImagenes,function (item,$index) {
                        var image = {};
                        image.image = $scope.rutaAbsoluta+"/publicidadpaneles/"+item.imagenelemento_url;
                        $scope.slides.push(image);
                        $scope.images.push($index);
                    });

                    if($scope.elemento.elemento_geolocalizacionx != null && $scope.elemento.elemento_geolocalizacionx != ""){
                        geox = $scope.elemento.elemento_geolocalizacionx*1;
                    }

                    if($scope.elemento.elemento_geolocalizaciony != null && $scope.elemento.elemento_geolocalizaciony != ""){
                        geoy = $scope.elemento.elemento_geolocalizaciony*1;
                    }

                    map = new google.maps.Map(document.getElementById('map'), {
                        center: {lat: geox, lng: geoy},
                        zoom: 16
                    });
                    // var image = 'https://www.pngfind.com/pngs/m/114-1147878_location-poi-pin-marker-position-red-map-google.png';
                    // var beachMarker = new google.maps.Marker({
                    //     position: {lat: geox, lng: geoy},
                    //     map: map,
                    //     icon: image
                    // });
                    var marker = new google.maps.Marker({
                        position: {lat: geox, lng: geoy},
                        map: map
                    });
                }

            });
        }

    }

    function enviarMensaje(){

        var objMensajeSolicitud = {};
        objMensajeSolicitud.elemento = $scope.elemento;
        objMensajeSolicitud.nombresCompletos = $scope.nombresCompletos;;
        objMensajeSolicitud.numeroTelefono = $scope.numeroTelefono;
        objMensajeSolicitud.correoElectronico = $scope.correoElectronico;
        objMensajeSolicitud.observacion = $scope.observacion;

        if(objMensajeSolicitud.nombresCompletos == "" || objMensajeSolicitud.numeroTelefono == ""||
            objMensajeSolicitud.numeroTelcorreoElectronicoefono == "" || objMensajeSolicitud.observacion == ""){
            window.alert("Por favor verifica que todos los datos sean correctos.");
            return;
        }

        $http.post('backend/rest/elemento/elemento/enviarCorreoSolicitudElemento',objMensajeSolicitud).success(function (response){

            if (response.tipo == 1) {
                window.alert("Tu solicitud fue registrada con exito.");
                $("#myModalLabel").modal('hide');
            }

        });

    }

    function descargarPDF(){
        window.open("backend/reports/report.php?type=pdf&or=P&page=elemento_elemento&name=elemento"+$scope.elemento.elemento_id+"&elemento_id="+$scope.elemento.elemento_id,"_blank");
    }

    function getAbsolutePath() {
        var loc = window.location;
        var pathName = loc.pathname.substring(0, loc.pathname.lastIndexOf('/') + 1);
        return loc.href.substring(0, loc.href.length - ((loc.pathname + loc.search + loc.hash).length - pathName.length));
    }

    _init();

}]);
