
App.controller('what', ['$scope','$http', function($scope,$http,$stateParams){

    var pagina = 1;
    if (!(parseInt(pagina)>0))
        pagina = "1";
    var registros = "10";
    $scope.departamentoList = [];
    $scope.departamentoSeleccionadoID = {};
    $scope.provinciaList = [];
    $scope.provinciaListAux = [];
    $scope.provinciaSeleccionadoID = {};
    $scope.distritoList = [];
    $scope.distritoListAux = [];
    $scope.distritoSeleccionadoID = {};
    $scope.tipoElementoList = [];
    $scope.tipoElementoSeleccionadoID = {};
    $scope.subTipoElementoList = [];
    $scope.subTipoElementoListAux = [];
    $scope.subtipoElementoSeleccionadoID = {};
    $scope.elementoFiltro = "";
    $scope.limiteFiltro = 10;
    $scope.verVencidos = 0;
    $scope.verTodos = "0";
    $scope.departamentoSeleccionado = "";


    $scope.estados = [
        {"id":"1","descripcion":"Libre"},
        {"id":"2","descripcion":"Alquilado"},
        {"id":"-1","descripcion":"Todos"},
    ];

    $scope.estadoSeleccionadoID = $scope.estados[2].id;

    $scope.mostrarProvinciaPorDepartamento = mostrarProvinciaPorDepartamento;
    $scope.mostrarDistritoPorProvincia = mostrarDistritoPorProvincia;
    $scope.getParameterByName = getParameterByName;
    $scope.cargarTipoElementos = cargarTipoElementos;
    $scope.cargarSubTipoElemento = cargarSubTipoElemento;
    $scope.mostrarSubtipoPorTipo = mostrarSubtipoPorTipo;
    $scope.cargarElementos = cargarElementos;


    /**
     * @param String name
     * @return String
     */
    function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search);
        return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    }

    function _init() {


        $scope.departamentoID = $scope.getParameterByName('departamentoID');

        if($scope.departamentoID*1>0){

            $http.get('backend/rest/pais/obtenerUbigeoPorPais').success(function (response){

                if (response.tipo == 1) {

                    $scope.departamentoList = response.datos.departamentoList;
                    $scope.departamentoSeleccionadoID = $scope.departamentoID;
                    $scope.provinciaListAux = response.datos.provinciaList;
                    $scope.distritoListAux = response.datos.distritoList;

                    angular.forEach($scope.departamentoList, function (departamento) {
                        if($scope.departamentoID*1 == departamento.departamento_id*1){
                            $scope.departamentoSeleccionado = departamento.departamento_departamento;
                        }
                    })

                    $scope.mostrarProvinciaPorDepartamento($scope.departamentoSeleccionadoID);

                }

            });

        }

        $scope.cargarTipoElementos();
    }

    function mostrarProvinciaPorDepartamento(departamento_id) {

        $scope.provinciaList.length = 0;

        angular.forEach($scope.provinciaListAux,function (provincia) {
            if(provincia.departamento_id*1 == departamento_id*1 ){
                $scope.provinciaList.push(provincia);
            }
        });

        $scope.provinciaSeleccionadoID = $scope.provinciaList[0].provincia_id;

        $scope.mostrarDistritoPorProvincia($scope.provinciaSeleccionadoID);

    }

    function mostrarDistritoPorProvincia(provincia_id) {
        $scope.distritoList.length = 0;
        angular.forEach($scope.distritoListAux,function (distrito) {
            if(distrito.provincia_id == provincia_id ){
                $scope.distritoList.push(distrito);
            }
        })

        $scope.distritoSeleccionadoID = $scope.distritoList[0].distrito_id;

    }


    function cargarTipoElementos() {

        $http.get('backend/rest/tipo/tipo/all').success(function (response){

            if (response.tipo == 1) {

                $scope.tipoElementoList=response.datos;

                if($scope.tipoElementoList.length){
                    $scope.tipoElementoSeleccionadoID = $scope.tipoElementoList[0].tipo_id;
                    $scope.cargarSubTipoElemento();
                }

            }

        });
    }

    function cargarSubTipoElemento() {

        $http.get('backend/rest/subtipo/subtipo/all').success(function (response){

            if (response.tipo == 1) {
                $scope.subTipoElementoListAux=response.datos;

                $scope.mostrarSubtipoPorTipo($scope.tipoElementoSeleccionadoID);

                $scope.cargarElementos();
            }

        });

    }

    function mostrarSubtipoPorTipo(tipo_id) {

        $scope.subTipoElementoList.length = 0;

        angular.forEach($scope.subTipoElementoListAux,function (subtipo) {
            if(subtipo.tipo_id == tipo_id ){
                $scope.subTipoElementoList.push(subtipo);
            }
        })

        if($scope.subTipoElementoList.length){
            $scope.subtipoElementoSeleccionadoID = $scope.subTipoElementoList[0].subtipo_id;
        }

    }

    function cargarElementos() {

        var distrito_id = $scope.distritoSeleccionadoID;
        var subtipo = $scope.subtipoElementoSeleccionadoID;
        var estado = $scope.estadoSeleccionadoID;

        $http.get('backend/rest/elemento/elemento/obtenerListaElementosParaWeb/'+distrito_id+'/'+subtipo+'/'+estado).success(function (response){

            if (response.tipo == 1) {

                $scope.elementoList=response.datos.elementoList;
                $scope.registros = registros;
                $scope.pagina = pagina;
                $scope.totalItems = response.datos.elementoCount;

            }

        });

    }

    _init();

}]);
