<?php
class ClienteController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$cliente_array = Cliente::getList();
		$datos = $cliente_array["cliente_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($cliente) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$cliente = new Cliente($cliente);
			$cliente->setCliente_estado(ACTIVO);
			$cliente->setCliente_fecharegistro(Utility::getFechaActual());
			if($cliente->getCliente_tipo() == 2){
			    $cliente->setCliente_apellidos("");
            }
			$resultado= $cliente->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$cliente){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$clienteObj = new Cliente($cliente);
			$clienteObj->setCliente_id($id);
            if($clienteObj->getCliente_tipo() == 2){
                $clienteObj->setCliente_apellidos("");
            }
			$resultado=$clienteObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Cliente::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$clienteObj = Cliente::getById($id);
			$clienteObj->setCliente_estado(INACTIVO);
			$resultado=$clienteObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getClienteListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$cliente_array = Cliente::getList(array(),(($pagina - 1) * $registros),$registros);
		$cliente_array = $cliente_array["cliente_array"];
		$array_data["clienteList"] = $cliente_array;
		$array_data["clienteCount"] = Cliente::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>