<?php
class DetallecampaniaController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$detallecampania_array = Detallecampania::getList();
		$datos = $detallecampania_array["detallecampania_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($detallecampania) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$detallecampania = new Detallecampania($detallecampania);
			$resultado= $detallecampania->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$detallecampania){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$detallecampaniaObj = new Detallecampania($detallecampania);
			$detallecampaniaObj->setDetallecampania_id($id);
			$resultado=$detallecampaniaObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Detallecampania::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$detallecampaniaObj = Detallecampania::getById($id);
			$detallecampaniaObj->setDetallecampania_estado(INACTIVO);
			$resultado=$detallecampaniaObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getDetallecampaniaListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$detallecampania_array = Detallecampania::getList(array(),(($pagina - 1) * $registros),$registros);
		$detallecampania_array = $detallecampania_array["detallecampania_array"];
		$array_data["detallecampaniaList"] = $detallecampania_array;
		$array_data["detallecampaniaCount"] = Detallecampania::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>