<?php
class ElementoController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$elemento_array = Elemento::getList();
		$datos = $elemento_array["elemento_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($elemento) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";

        $elemento = new Elemento($elemento);
        $elemento->elemento_estavencido = NO;
        if($elemento->elemento_id*1>0){
            $mensajes[] = "Error, posiblemente el elemento ya haya sido regiostrado";
            $tipo = ERROR;
        }

		if (empty($mensajes)) {

		    $array_imagenes = array();


            $codigoUnico = "elemento-" . Date("YmdHis");
			$elemento->setElemento_codigounico(trim($codigoUnico));
			$elemento->setElemento_estavencido(NO);

            if(isset($elemento->listaImagenes)){
                $array_imagenes = $elemento->listaImagenes;
            }

            if(isset($elemento->listaArchivos)){
                $array_archivos = $elemento->listaArchivos;
            }

			$resultado= $elemento->insert();

			if ($resultado) {

			    foreach ($array_imagenes as $imagen){
			        $imagenElemento = new Imagenelemento();
			        $imagenElemento->setImagenelemento_url($imagen->imagenelemento_url);
			        $imagenElemento->setImagenelemento_estado(ACTIVO);
			        $imagenElemento->setElemento_id($resultado);
                    $imagenElemento->insert();
                }

                foreach ($array_archivos as $archivo){
                    $archivoElemento = new Archivoelemento();
                    $archivoElemento->setElemento_id($resultado);
                    $archivoElemento->setArchivoelemento_estadodoc($archivo->archivoelemento_estadodoc);
                    $archivoElemento->setArchivoelemento_estado(ACTIVO);
                    $archivoElemento->setArchivoelemento_url($archivo->archivoelemento_url);
                    $archivoElemento->setArchivoelemento_fechavencimiento($archivo->archivoelemento_fechavencimiento);
                    $archivoElemento->setArchivoelemento_tipo($archivo->archivoelemento_tipo);
                    $archivoElemento->insert();
                }

				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$elemento){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$elementoSinCliente = false;
		if (empty($mensajes)) {

            $array_archivos = array();

            $elementoObj = new Elemento($elemento);

            if(isset($elementoObj->listaArchivos)){
                $array_archivos = $elementoObj->listaArchivos;
            }

            $elementoObj->setElemento_id($id);
            if($elementoObj->getCliente_id() == -1){
                $elementoSinCliente = true;
                $elementoObj->setCliente_id(null);
            }
			$resultado=$elementoObj->update();

			if ($resultado) {

                if($elementoSinCliente){
                    $elementoObj->marcarElementoSinCliente();
                }

                foreach ($array_archivos as $archivo){
                    $archivoElemento = new Archivoelemento();
                    $archivoElemento->setArchivoelemento_id($archivo->archivoelemento_id);
                    $archivoElemento->setElemento_id($archivo->elemento_id);
                    $archivoElemento->setArchivoelemento_estadodoc($archivo->archivoelemento_estadodoc);
                    $archivoElemento->setArchivoelemento_estado($archivo->archivoelemento_estado);
                    $archivoElemento->setArchivoelemento_url($archivo->archivoelemento_url);
                    $archivoElemento->setArchivoelemento_fechavencimiento($archivo->archivoelemento_fechavencimiento);
                    $archivoElemento->setArchivoelemento_tipo($archivo->archivoelemento_tipo);
                    $archivoElemento->update();
                }

				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
        $datos = null;

        $obj = Elemento::getById($id);

        if($obj){
            $obj->listaImagenes = Imagenelemento::getByFields(array(
               array("field"=>"elemento_id","value"=>$obj->elemento_id, "operator"=>"="),
               array("field"=>"imagenelemento_estado","value"=>ACTIVO, "operator"=>"=")
            ))["imagenelemento_array"];

            $obj->archivosElemento = Archivoelemento::getByFields(array(
                array("field"=>"elemento_id","value"=>$obj->elemento_id, "operator"=>"="),
                array("field"=>"archivoelemento_estado","value"=>ACTIVO, "operator"=>"=")
            ))["archivoelemento_array"];

            $datos = $obj;
        }else{
            $tipo = ERROR;
        }


		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$elementoObj = Elemento::getById($id);
			$elementoObj->setElemento_estado(INACTIVO);
			$resultado=$elementoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getElementoListPaginado($distrito,$subtipo,$vencidos){
		$data = array();
		$tipo = SUCCESS;

        // SOLUCIÓN OPTIMIZADA: Usar query con JOINs en lugar de N+1 queries
        // Mejora rendimiento de ~30 segundos a ~1 segundo
        $elemento_array = Elemento::obtenerListaElementosOptimizado($distrito,$subtipo,$vencidos);

        $fechaActual = Utility::getFechaActual();
        $enTresMeses = Utility::addTimeToDate($fechaActual,"+3 months");

        foreach ($elemento_array as $elemento){
            // subtipo y distrito ya vienen del JOIN, no necesitan query adicional

            $continuo = true;

            // valido fecha vencimiento del elemento
            $archivoContrato = Archivoelemento::getByFields(array(
                array("field"=>"archivoelemento_tipo","value"=>CONTRATO,"operator"=>"="),
                array("field"=>"elemento_id","value"=>$elemento->elemento_id,"operator"=>"="),
            ))["archivoelemento_array"];

            if(sizeof($archivoContrato)){
                $archivoContrato = $archivoContrato[0];

                if($archivoContrato->archivoelemento_fechavencimiento <= $fechaActual){
                    $elemento->elemento_estado = ELEMENTO_VENCIDO;
                    $elemento->update();
                    $continuo = false;
                }

                $diasPendientes = Utility::getDiferenciaTiempoDias($enTresMeses,$archivoContrato->archivoelemento_fechavencimiento);

                if($diasPendientes<90){
                    $elemento->elemento_estavencido = ELEMENTO_VENCIDO;
                    // TODO: Mover envío de email a proceso separado (CRON o endpoint manual)
                    // Utility::enviarCorreoVencimiento($elemento,"jpsantillangarcia@gmail.com");
                }
            }

            if($continuo){
                $archivoLicencia = Archivoelemento::getByFields(array(
                    array("field"=>"archivoelemento_tipo","value"=>LICENCIA,"operator"=>"="),
                    array("field"=>"elemento_id","value"=>$elemento->elemento_id,"operator"=>"="),
                ))["archivoelemento_array"];

                if(sizeof($archivoLicencia)){
                    $archivoLicencia = $archivoLicencia[0];

                    if($archivoLicencia->archivoelemento_fechavencimiento <= $fechaActual){
                        $elemento->elemento_estavencido = SI;
                        $elemento->update();
                    }

                    if($diasPendientes<90){
                        $elemento->elemento_estavencido = SI;
                        // TODO: Mover envío de email a proceso separado (CRON o endpoint manual)
                        // Utility::enviarCorreoVencimiento($elemento,"jpsantillangarcia@gmail.com");
                    }

                }
            }
        }

		$array_data["elementoList"] = $elemento_array;
		$array_data["elementoCount"] = Elemento::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>