<?php
class ImagenelementoController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$imagenelemento_array = Imagenelemento::getList();
		$datos = $imagenelemento_array["imagenelemento_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($imagenelemento) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$imagenelemento = new Imagenelemento($imagenelemento);
			$resultado= $imagenelemento->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$imagenelemento){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$imagenelementoObj = new Imagenelemento($imagenelemento);
			$imagenelementoObj->setImagenelemento_id($id);
			$resultado=$imagenelementoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Imagenelemento::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$imagenelementoObj = Imagenelemento::getById($id);
			$imagenelementoObj->setImagenelemento_estado(INACTIVO);
			$resultado=$imagenelementoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getImagenelementoListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$imagenelemento_array = Imagenelemento::getList(array(),(($pagina - 1) * $registros),$registros);
		$imagenelemento_array = $imagenelemento_array["imagenelemento_array"];
		$array_data["imagenelementoList"] = $imagenelemento_array;
		$array_data["imagenelementoCount"] = Imagenelemento::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>