<?php
class PaisController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$pais_array = Pais::getList();
		$datos = $pais_array["pais_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($pais) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$pais = new Pais($pais);
			$resultado= $pais->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$pais){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$paisObj = new Pais($pais);
			$paisObj->setPais_id($id);
			$resultado=$paisObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Pais::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$paisObj = Pais::getById($id);
			$paisObj->setPais_codigopostal(INACTIVO);
			$resultado=$paisObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getPaisListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$pais_array = Pais::getList(array(),(($pagina - 1) * $registros),$registros);
		$pais_array = $pais_array["pais_array"];
		$array_data["paisList"] = $pais_array;
		$array_data["paisCount"] = Pais::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

	public function obtenerUbigeoPorPais(){

        $data = array();
        $tipo = SUCCESS;

        $pais_array = Pais::getByFields()["pais_array"];
        $departamento_array = Departamento::getByFields()["departamento_array"];
        $provincia_array = Provincia::getByFields()["provincia_array"];
        $distrito_array = Distrito::getByFields( array(), array(),0,2000)["distrito_array"];

        $datos = new stdClass();
        $datos->paisList = $pais_array;
        $datos->departamentoList = $departamento_array;
        $datos->provinciaList = $provincia_array;
        $datos->distritoList = $distrito_array;

        $data["tipo"] = $tipo;
        $data["datos"] = $datos;
        return $data;

    }

}
?>