<?php
class PermisoController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$permiso_array = Permiso::getList();
		$datos = $permiso_array["permiso_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($permiso) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$permiso = new Permiso($permiso);
			$resultado= $permiso->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$permiso){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$permisoObj = new Permiso($permiso);
			$permisoObj->setPermiso_id($id);
			$resultado=$permisoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Permiso::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$permisoObj = Permiso::getById($id);
			$permisoObj->setPermiso_modulo(INACTIVO);
			$resultado=$permisoObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getPermisoListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$permiso_array = Permiso::getList(array(),(($pagina - 1) * $registros),$registros);
		$permiso_array = $permiso_array["permiso_array"];
		$array_data["permisoList"] = $permiso_array;
		$array_data["permisoCount"] = Permiso::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>