<?php
class ProvinciaController {
	function __construct() {}

	public function getAllData() {
		$data = array();
		$tipo = SUCCESS;
		$provincia_array = Provincia::getList();
		$datos = $provincia_array["provincia_array"];
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function add($provincia) {
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		$datos = "";
		if (empty($mensajes)) {
			$provincia = new Provincia($provincia);
			$resultado= $provincia->insert();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se agrego con éxito.";
				$datos = $resultado;
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al crear. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function update($id,$provincia){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$provinciaObj = new Provincia($provincia);
			$provinciaObj->setProvincia_id($id);
			$resultado=$provinciaObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se modificó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al modificar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}
	public function getById($id) {
		$data = array();
		$tipo = SUCCESS;
		$obj = Provincia::getById($id);
		if(!$obj) $tipo = ERROR;
		$datos = $obj;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}
	public function delete($id){
		$data = array();
		$mensajes = array();
		$tipo = SUCCESS;
		if (empty($mensajes)) {
			$provinciaObj = Provincia::getById($id);
			$provinciaObj->setDepartamento_id(INACTIVO);
			$resultado=$provinciaObj->update();
			if ($resultado) {
				$tipo = SUCCESS;
				$mensajes[] = "Se eliminó con éxito.";
			} else {
				$tipo = ERROR;
				$mensajes[] = "Se produjo un error al eliminar. Intentalo de nuevo.";
			}
		}
		$data["mensajes"] = $mensajes;
		$data["tipo"] = $tipo;
		return $data;
	}

	public function getProvinciaListPaginado($pagina,$registros){
		$data = array();
		$tipo = SUCCESS;
		$provincia_array = Provincia::getList(array(),(($pagina - 1) * $registros),$registros);
		$provincia_array = $provincia_array["provincia_array"];
		$array_data["provinciaList"] = $provincia_array;
		$array_data["provinciaCount"] = Provincia::getTotalRows();
		$datos = $array_data;
		$data["tipo"] = $tipo;
		$data["datos"] = $datos;
		return $data;
	}

}
?>