<?php

class Security
{
    public static $randomAccessReferenceMap;
    private $isLogged = false;

    public function __construct($isRest)
    {
        if (isset($_GET["token"])) {
        } else if (!isset($_SESSION["usuario_id"])) {
            if ($isRest) {
                exit(json_encode(array("tipo" => 401)));
            } else {
                $this->isLogged = false;
            }
        } else {
            $this->isLogged = true;
        }
    }

    public static function tienePermiso($modulo_id, $tipo)
    {
        if ($tipo == "1")// buscar en bd
        {
            $array_permisousuario = Permisousuario::getByFields(array(
                array("field" => "usuario_id", "value" => Security::getCurrentUserId(), "operator" => "="),
                array("field" => "modulo_id", "value" => $modulo_id, "operator" => "="),
                array("field" => "permiso_permiso", "value" => "1", "operator" => "=")
            ));
            $array_permisousuario = $array_permisousuario["permiso_array"];
            if (sizeof($array_permisousuario) > 0) {
                return true;
            } else {
                return false;
            }
        }
        if ($tipo == "2") {
            if (!isset($_SESSION["permisos"])) return false;
            $array_permisos = explode("-", $_SESSION["permisos"]);
            foreach ($array_permisos as $value) {
                if ($value == $modulo_id) return true;
            }
            return false;
        }
    }

    public static function loguear($username, $password)
    {
        $usuario = Usuario::getByFields(array(array("field" => "usuario_usuario", "operator" => "=", "conditional" => "AND", "value" => $username),
            array("field" => "usuario_clave", "operator" => "=", "conditional" => "AND", "value" => $password),
            array("field" => "usuario_estado", "operator" => "=", "conditional" => "AND", "value" => 1)
        ));
        $usuario_array = $usuario["usuario_array"];
        if (sizeof($usuario_array) > 0) {
            $usuarioObj = $usuario_array[0];
            return $usuarioObj;
        } else {
            return new Usuario();
        }
    }

    public function isLogged()
    {
        return $this->isLogged;
    }

    public static function canWrite($modulo_id)
    {
    }

    public static function setSession($nombre, $valor)
    {
        if (isset($_SESSION[$nombre])) {
            $_SESSION[$nombre] = $valor;
        } else {
            $_SESSION[$nombre] = $valor;
        }
    }

    public static function logout()
    {
        session_destroy();
    }

    public static function getCurrentTrabajadorObject()
    {
        return Trabajador::getById(Security::getCurrentTrabajadorId());
    }

    public static function getCurrentUserObject()
    {
        return Usuario::getById(Security::getCurrentUserId());
    }

    public static function getSession($nombre)
    {
        if (isset($_SESSION[$nombre])) {
            return $_SESSION[$nombre];
        } else {
            return false;
        }
    }

    public static function encrypt($object)
    {
        $indirectReference = Security::$randomAccessReferenceMap->getIndirectReference($object);
        if ($indirectReference == null) {
            $indirectReference = Security::$randomAccessReferenceMap->addDirectReference($object);
            return (String)$indirectReference;
        }
        return (String)$indirectReference;
    }

    public static function decrypt($object)
    {
        return Security::$randomAccessReferenceMap->getDirectReference((String)$object);
    }

    public static function getCurrentUserId()
    {
        if (isset($_SESSION["usuario_id"])) {
            return $_SESSION["usuario_id"];
        } else {
            return "";
        }
    }

    public static function getCurrentUser()
    {
        $objUsuario = Usuario::getById(Security::getCurrentUserId());
        if ($objUsuario) {
            return $objUsuario;
        } else {
            return "";
        }
    }

    public static function getCurrentUsername()
    {
        $objUsuario = Usuario::getById(Security::getCurrentUserId());
        if ($objUsuario) {
            return $objUsuario->getUsuario_usuario();
        } else {
            return "";
        }
    }

    public static function getCurrentTrabajadorId()
    {
        if (isset($_SESSION["trabajador_id"])) {
            return $_SESSION["trabajador_id"];
        } else {
            return "";
        }
    }

    public static function getCurrentTipoId()
    {
        if (isset($_SESSION["tipotrabajador_id"])) {
            return $_SESSION["tipotrabajador_id"];
        } else {
            return "";
        }
    }

    public static function getCurrentSucursalId()
    {
        if (isset($_SESSION["sucursal_id"])) {
            return $_SESSION["sucursal_id"];
        } else {
            return "";
        }
    }


    public static function obtenerPermisosPorusuario($usuarioLogin)
    {
        $array_lista_permisos = array();
        $array_permisos = Permiso::getByFields(array(
            array("field" => "usuario_id", "value" => $usuarioLogin->getUsuario_id(), "operator" => "="),
            array("field" => "permiso_permiso", "value" => "1", "operator" => "=")
        ));
        $array_permisos = $array_permisos["permiso_array"];
        foreach ($array_permisos as $value) {
            $modulo = Modulo::getById($value->modulo_id);
            $array_lista_permisos[] = $modulo;
        }
        return $array_lista_permisos;
    }

    public static function getCurrentMonedaId()
    {
        if (isset($_SESSION["monedadefecto_id"])) {
            return $_SESSION["monedadefecto_id"];
        } else {
            return "";
        }
    }

    public static function getCurrentMoneda()
    {
        return Moneda::getMonedaPorDefecto(Security::getCurrentMonedaId());
    }
}

?>
