<?php
class ClienteEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $cliente_id;
	public $cliente_nombres;
	public $cliente_apellidos;
	public $cliente_dniruc;
	public $cliente_tipo;
	public $cliente_direccion;
	public $cliente_telefono;
	public $cliente_correo;
	public $cliente_usuario;
	public $cliente_clave;
	public $cliente_fecharegistro;
	public $cliente_estado;

	public function setCliente_id($cliente_id){
		$this->cliente_id = $cliente_id;
	}
	public function getCliente_id(){
		return $this->cliente_id;
	}

	public function setCliente_nombres($cliente_nombres){
		$this->cliente_nombres = $cliente_nombres;
	}
	public function getCliente_nombres(){
		return $this->cliente_nombres;
	}

	public function setCliente_apellidos($cliente_apellidos){
		$this->cliente_apellidos = $cliente_apellidos;
	}
	public function getCliente_apellidos(){
		return $this->cliente_apellidos;
	}

	public function setCliente_dniruc($cliente_dniruc){
		$this->cliente_dniruc = $cliente_dniruc;
	}
	public function getCliente_dniruc(){
		return $this->cliente_dniruc;
	}

	public function setCliente_tipo($cliente_tipo){
		$this->cliente_tipo = $cliente_tipo;
	}
	public function getCliente_tipo(){
		return $this->cliente_tipo;
	}

	public function setCliente_direccion($cliente_direccion){
		$this->cliente_direccion = $cliente_direccion;
	}
	public function getCliente_direccion(){
		return $this->cliente_direccion;
	}

	public function setCliente_telefono($cliente_telefono){
		$this->cliente_telefono = $cliente_telefono;
	}
	public function getCliente_telefono(){
		return $this->cliente_telefono;
	}

	public function setCliente_correo($cliente_correo){
		$this->cliente_correo = $cliente_correo;
	}
	public function getCliente_correo(){
		return $this->cliente_correo;
	}

	public function setCliente_usuario($cliente_usuario){
		$this->cliente_usuario = $cliente_usuario;
	}
	public function getCliente_usuario(){
		return $this->cliente_usuario;
	}

	public function setCliente_clave($cliente_clave){
		$this->cliente_clave = $cliente_clave;
	}
	public function getCliente_clave(){
		return $this->cliente_clave;
	}

	public function setCliente_fecharegistro($cliente_fecharegistro){
		$this->cliente_fecharegistro = $cliente_fecharegistro;
	}
	public function getCliente_fecharegistro(){
		return $this->cliente_fecharegistro;
	}

	public function setCliente_estado($cliente_estado){
		$this->cliente_estado = $cliente_estado;
	}
	public function getCliente_estado(){
		return $this->cliente_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->cliente_nombres))
				$query.="cliente_nombres, ";
			if(isset($this->cliente_apellidos))
				$query.="cliente_apellidos, ";
			if(isset($this->cliente_dniruc))
				$query.="cliente_dniruc, ";
			if(isset($this->cliente_tipo))
				$query.="cliente_tipo, ";
			if(isset($this->cliente_direccion))
				$query.="cliente_direccion, ";
			if(isset($this->cliente_telefono))
				$query.="cliente_telefono, ";
			if(isset($this->cliente_correo))
				$query.="cliente_correo, ";
			if(isset($this->cliente_usuario))
				$query.="cliente_usuario, ";
			if(isset($this->cliente_clave))
				$query.="cliente_clave, ";
			if(isset($this->cliente_fecharegistro))
				$query.="cliente_fecharegistro, ";
			if(isset($this->cliente_estado))
				$query.="cliente_estado, ";
			if(isset($this->cliente_nombres))
				$query2.=":cliente_nombres, ";
			if(isset($this->cliente_apellidos))
				$query2.=":cliente_apellidos, ";
			if(isset($this->cliente_dniruc))
				$query2.=":cliente_dniruc, ";
			if(isset($this->cliente_tipo))
				$query2.=":cliente_tipo, ";
			if(isset($this->cliente_direccion))
				$query2.=":cliente_direccion, ";
			if(isset($this->cliente_telefono))
				$query2.=":cliente_telefono, ";
			if(isset($this->cliente_correo))
				$query2.=":cliente_correo, ";
			if(isset($this->cliente_usuario))
				$query2.=":cliente_usuario, ";
			if(isset($this->cliente_clave))
				$query2.=":cliente_clave, ";
			if(isset($this->cliente_fecharegistro))
				$query2.=":cliente_fecharegistro, ";
			if(isset($this->cliente_estado))
				$query2.=":cliente_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO cliente(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->cliente_nombres))
				$stmt->bindParam(":cliente_nombres", $this->cliente_nombres,	PDO::PARAM_STR);
			if(isset($this->cliente_apellidos))
				$stmt->bindParam(":cliente_apellidos", $this->cliente_apellidos,	PDO::PARAM_STR);
			if(isset($this->cliente_dniruc))
				$stmt->bindParam(":cliente_dniruc", $this->cliente_dniruc,	PDO::PARAM_STR);
			if(isset($this->cliente_tipo))
				$stmt->bindParam(":cliente_tipo", $this->cliente_tipo,	PDO::PARAM_STR);
			if(isset($this->cliente_direccion))
				$stmt->bindParam(":cliente_direccion", $this->cliente_direccion,	PDO::PARAM_STR);
			if(isset($this->cliente_telefono))
				$stmt->bindParam(":cliente_telefono", $this->cliente_telefono,	PDO::PARAM_STR);
			if(isset($this->cliente_correo))
				$stmt->bindParam(":cliente_correo", $this->cliente_correo,	PDO::PARAM_STR);
			if(isset($this->cliente_usuario))
				$stmt->bindParam(":cliente_usuario", $this->cliente_usuario,	PDO::PARAM_STR);
			if(isset($this->cliente_clave))
				$stmt->bindParam(":cliente_clave", $this->cliente_clave,	PDO::PARAM_STR);
			if(isset($this->cliente_fecharegistro))
				$stmt->bindParam(":cliente_fecharegistro", $this->cliente_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->cliente_estado))
				$stmt->bindParam(":cliente_estado", $this->cliente_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE cliente SET ";
			if(isset($this->cliente_nombres))
				$query.="cliente_nombres=:cliente_nombres, ";
			if(isset($this->cliente_apellidos))
				$query.="cliente_apellidos=:cliente_apellidos, ";
			if(isset($this->cliente_dniruc))
				$query.="cliente_dniruc=:cliente_dniruc, ";
			if(isset($this->cliente_tipo))
				$query.="cliente_tipo=:cliente_tipo, ";
			if(isset($this->cliente_direccion))
				$query.="cliente_direccion=:cliente_direccion, ";
			if(isset($this->cliente_telefono))
				$query.="cliente_telefono=:cliente_telefono, ";
			if(isset($this->cliente_correo))
				$query.="cliente_correo=:cliente_correo, ";
			if(isset($this->cliente_usuario))
				$query.="cliente_usuario=:cliente_usuario, ";
			if(isset($this->cliente_clave))
				$query.="cliente_clave=:cliente_clave, ";
			if(isset($this->cliente_fecharegistro))
				$query.="cliente_fecharegistro=:cliente_fecharegistro, ";
			if(isset($this->cliente_estado))
				$query.="cliente_estado=:cliente_estado, ";
			if($query!="UPDATE cliente SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE cliente_id=:cliente_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":cliente_id", $this->cliente_id,	PDO::PARAM_STR);
			if(isset($this->cliente_nombres))
				$stmt->bindParam(":cliente_nombres",	$this->cliente_nombres,	PDO::PARAM_STR);
			if(isset($this->cliente_apellidos))
				$stmt->bindParam(":cliente_apellidos",	$this->cliente_apellidos,	PDO::PARAM_STR);
			if(isset($this->cliente_dniruc))
				$stmt->bindParam(":cliente_dniruc",	$this->cliente_dniruc,	PDO::PARAM_STR);
			if(isset($this->cliente_tipo))
				$stmt->bindParam(":cliente_tipo",	$this->cliente_tipo,	PDO::PARAM_STR);
			if(isset($this->cliente_direccion))
				$stmt->bindParam(":cliente_direccion",	$this->cliente_direccion,	PDO::PARAM_STR);
			if(isset($this->cliente_telefono))
				$stmt->bindParam(":cliente_telefono",	$this->cliente_telefono,	PDO::PARAM_STR);
			if(isset($this->cliente_correo))
				$stmt->bindParam(":cliente_correo",	$this->cliente_correo,	PDO::PARAM_STR);
			if(isset($this->cliente_usuario))
				$stmt->bindParam(":cliente_usuario",	$this->cliente_usuario,	PDO::PARAM_STR);
			if(isset($this->cliente_clave))
				$stmt->bindParam(":cliente_clave",	$this->cliente_clave,	PDO::PARAM_STR);
			if(isset($this->cliente_fecharegistro))
				$stmt->bindParam(":cliente_fecharegistro",	$this->cliente_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->cliente_estado))
				$stmt->bindParam(":cliente_estado",	$this->cliente_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM cliente WHERE cliente_id=:cliente_id 
			LIMIT 1");
			$stmt->bindParam(":cliente_id",	$this->cliente_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($cliente_id) {
		global $pdo;
		$sql = "SELECT * FROM cliente WHERE cliente_id=:cliente_id AND cliente_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":cliente_id",$cliente_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Cliente($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "cliente_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Cliente", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM cliente WHERE cliente_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}