<?php
class DetallecampaniaEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $detallecampania_id;
	public $campania_id;
	public $elemento_id;
	public $detallecampania_estado;

	public function setDetallecampania_id($detallecampania_id){
		$this->detallecampania_id = $detallecampania_id;
	}
	public function getDetallecampania_id(){
		return $this->detallecampania_id;
	}

	public function setCampania_id($campania_id){
		$this->campania_id = $campania_id;
	}
	public function getCampania_id(){
		return $this->campania_id;
	}

	public function setElemento_id($elemento_id){
		$this->elemento_id = $elemento_id;
	}
	public function getElemento_id(){
		return $this->elemento_id;
	}

	public function setDetallecampania_estado($detallecampania_estado){
		$this->detallecampania_estado = $detallecampania_estado;
	}
	public function getDetallecampania_estado(){
		return $this->detallecampania_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->campania_id))
				$query.="campania_id, ";
			if(isset($this->elemento_id))
				$query.="elemento_id, ";
			if(isset($this->detallecampania_estado))
				$query.="detallecampania_estado, ";
			if(isset($this->campania_id))
				$query2.=":campania_id, ";
			if(isset($this->elemento_id))
				$query2.=":elemento_id, ";
			if(isset($this->detallecampania_estado))
				$query2.=":detallecampania_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO detallecampania(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->campania_id))
				$stmt->bindParam(":campania_id", $this->campania_id,	PDO::PARAM_STR);
			if(isset($this->elemento_id))
				$stmt->bindParam(":elemento_id", $this->elemento_id,	PDO::PARAM_STR);
			if(isset($this->detallecampania_estado))
				$stmt->bindParam(":detallecampania_estado", $this->detallecampania_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE detallecampania SET ";
			if(isset($this->campania_id))
				$query.="campania_id=:campania_id, ";
			if(isset($this->elemento_id))
				$query.="elemento_id=:elemento_id, ";
			if(isset($this->detallecampania_estado))
				$query.="detallecampania_estado=:detallecampania_estado, ";
			if($query!="UPDATE detallecampania SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE detallecampania_id=:detallecampania_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":detallecampania_id", $this->detallecampania_id,	PDO::PARAM_STR);
			if(isset($this->campania_id))
				$stmt->bindParam(":campania_id",	$this->campania_id,	PDO::PARAM_STR);
			if(isset($this->elemento_id))
				$stmt->bindParam(":elemento_id",	$this->elemento_id,	PDO::PARAM_STR);
			if(isset($this->detallecampania_estado))
				$stmt->bindParam(":detallecampania_estado",	$this->detallecampania_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM detallecampania WHERE detallecampania_id=:detallecampania_id 
			LIMIT 1");
			$stmt->bindParam(":detallecampania_id",	$this->detallecampania_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($detallecampania_id) {
		global $pdo;
		$sql = "SELECT * FROM detallecampania WHERE detallecampania_id=:detallecampania_id AND detallecampania_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":detallecampania_id",$detallecampania_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Detallecampania($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "detallecampania_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Detallecampania", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM detallecampania WHERE detallecampania_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}