<?php
class ElementoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $elemento_id;
	public $subtipo_id;
	public $elemento_titulo;
	public $elemento_geolocalizacionx;
	public $elemento_geolocalizaciony;
	public $elemento_codigounico;
	public $elemento_alto;
	public $elemento_ancho;
	public $elemento_estado;
	public $campania_id;
	public $elemento_direccioncompleta;
	public $elemento_fechavencimiento;
	public $distrito_id;
	public $elemento_estavencido;
	public $cliente_id;

	public function setElemento_id($elemento_id){
		$this->elemento_id = $elemento_id;
	}
	public function getElemento_id(){
		return $this->elemento_id;
	}

	public function setSubtipo_id($subtipo_id){
		$this->subtipo_id = $subtipo_id;
	}
	public function getSubtipo_id(){
		return $this->subtipo_id;
	}

	public function setElemento_titulo($elemento_titulo){
		$this->elemento_titulo = $elemento_titulo;
	}
	public function getElemento_titulo(){
		return $this->elemento_titulo;
	}

	public function setElemento_geolocalizacionx($elemento_geolocalizacionx){
		$this->elemento_geolocalizacionx = $elemento_geolocalizacionx;
	}
	public function getElemento_geolocalizacionx(){
		return $this->elemento_geolocalizacionx;
	}

	public function setElemento_geolocalizaciony($elemento_geolocalizaciony){
		$this->elemento_geolocalizaciony = $elemento_geolocalizaciony;
	}
	public function getElemento_geolocalizaciony(){
		return $this->elemento_geolocalizaciony;
	}

	public function setElemento_codigounico($elemento_codigounico){
		$this->elemento_codigounico = $elemento_codigounico;
	}
	public function getElemento_codigounico(){
		return $this->elemento_codigounico;
	}

	public function setElemento_alto($elemento_alto){
		$this->elemento_alto = $elemento_alto;
	}
	public function getElemento_alto(){
		return $this->elemento_alto;
	}

	public function setElemento_ancho($elemento_ancho){
		$this->elemento_ancho = $elemento_ancho;
	}
	public function getElemento_ancho(){
		return $this->elemento_ancho;
	}

	public function setElemento_estado($elemento_estado){
		$this->elemento_estado = $elemento_estado;
	}
	public function getElemento_estado(){
		return $this->elemento_estado;
	}

	public function setCampania_id($campania_id){
		$this->campania_id = $campania_id;
	}
	public function getCampania_id(){
		return $this->campania_id;
	}

	public function setElemento_direccioncompleta($elemento_direccioncompleta){
		$this->elemento_direccioncompleta = $elemento_direccioncompleta;
	}
	public function getElemento_direccioncompleta(){
		return $this->elemento_direccioncompleta;
	}

	public function setElemento_fechavencimiento($elemento_fechavencimiento){
		$this->elemento_fechavencimiento = $elemento_fechavencimiento;
	}
	public function getElemento_fechavencimiento(){
		return $this->elemento_fechavencimiento;
	}

	public function setDistrito_id($distrito_id){
		$this->distrito_id = $distrito_id;
	}
	public function getDistrito_id(){
		return $this->distrito_id;
	}

	public function setElemento_estavencido($elemento_estavencido){
		$this->elemento_estavencido = $elemento_estavencido;
	}
	public function getElemento_estavencido(){
		return $this->elemento_estavencido;
	}

	public function setCliente_id($cliente_id){
		$this->cliente_id = $cliente_id;
	}
	public function getCliente_id(){
		return $this->cliente_id;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->subtipo_id))
				$query.="subtipo_id, ";
			if(isset($this->elemento_titulo))
				$query.="elemento_titulo, ";
			if(isset($this->elemento_geolocalizacionx))
				$query.="elemento_geolocalizacionx, ";
			if(isset($this->elemento_geolocalizaciony))
				$query.="elemento_geolocalizaciony, ";
			if(isset($this->elemento_codigounico))
				$query.="elemento_codigounico, ";
			if(isset($this->elemento_alto))
				$query.="elemento_alto, ";
			if(isset($this->elemento_ancho))
				$query.="elemento_ancho, ";
			if(isset($this->elemento_estado))
				$query.="elemento_estado, ";
			if(isset($this->campania_id))
				$query.="campania_id, ";
			if(isset($this->elemento_direccioncompleta))
				$query.="elemento_direccioncompleta, ";
			if(isset($this->elemento_fechavencimiento))
				$query.="elemento_fechavencimiento, ";
			if(isset($this->distrito_id))
				$query.="distrito_id, ";
			if(isset($this->elemento_estavencido))
				$query.="elemento_estavencido, ";
			if(isset($this->cliente_id))
				$query.="cliente_id, ";
			if(isset($this->subtipo_id))
				$query2.=":subtipo_id, ";
			if(isset($this->elemento_titulo))
				$query2.=":elemento_titulo, ";
			if(isset($this->elemento_geolocalizacionx))
				$query2.=":elemento_geolocalizacionx, ";
			if(isset($this->elemento_geolocalizaciony))
				$query2.=":elemento_geolocalizaciony, ";
			if(isset($this->elemento_codigounico))
				$query2.=":elemento_codigounico, ";
			if(isset($this->elemento_alto))
				$query2.=":elemento_alto, ";
			if(isset($this->elemento_ancho))
				$query2.=":elemento_ancho, ";
			if(isset($this->elemento_estado))
				$query2.=":elemento_estado, ";
			if(isset($this->campania_id))
				$query2.=":campania_id, ";
			if(isset($this->elemento_direccioncompleta))
				$query2.=":elemento_direccioncompleta, ";
			if(isset($this->elemento_fechavencimiento))
				$query2.=":elemento_fechavencimiento, ";
			if(isset($this->distrito_id))
				$query2.=":distrito_id, ";
			if(isset($this->elemento_estavencido))
				$query2.=":elemento_estavencido, ";
			if(isset($this->cliente_id))
				$query2.=":cliente_id, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO elemento(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->subtipo_id))
				$stmt->bindParam(":subtipo_id", $this->subtipo_id,	PDO::PARAM_STR);
			if(isset($this->elemento_titulo))
				$stmt->bindParam(":elemento_titulo", $this->elemento_titulo,	PDO::PARAM_STR);
			if(isset($this->elemento_geolocalizacionx))
				$stmt->bindParam(":elemento_geolocalizacionx", $this->elemento_geolocalizacionx,	PDO::PARAM_STR);
			if(isset($this->elemento_geolocalizaciony))
				$stmt->bindParam(":elemento_geolocalizaciony", $this->elemento_geolocalizaciony,	PDO::PARAM_STR);
			if(isset($this->elemento_codigounico))
				$stmt->bindParam(":elemento_codigounico", $this->elemento_codigounico,	PDO::PARAM_STR);
			if(isset($this->elemento_alto))
				$stmt->bindParam(":elemento_alto", $this->elemento_alto,	PDO::PARAM_STR);
			if(isset($this->elemento_ancho))
				$stmt->bindParam(":elemento_ancho", $this->elemento_ancho,	PDO::PARAM_STR);
			if(isset($this->elemento_estado))
				$stmt->bindParam(":elemento_estado", $this->elemento_estado,	PDO::PARAM_STR);
			if(isset($this->campania_id))
				$stmt->bindParam(":campania_id", $this->campania_id,	PDO::PARAM_STR);
			if(isset($this->elemento_direccioncompleta))
				$stmt->bindParam(":elemento_direccioncompleta", $this->elemento_direccioncompleta,	PDO::PARAM_STR);
			if(isset($this->elemento_fechavencimiento))
				$stmt->bindParam(":elemento_fechavencimiento", $this->elemento_fechavencimiento,	PDO::PARAM_STR);
			if(isset($this->distrito_id))
				$stmt->bindParam(":distrito_id", $this->distrito_id,	PDO::PARAM_STR);
			if(isset($this->elemento_estavencido))
				$stmt->bindParam(":elemento_estavencido", $this->elemento_estavencido,	PDO::PARAM_STR);
			if(isset($this->cliente_id))
				$stmt->bindParam(":cliente_id", $this->cliente_id,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE elemento SET ";
			if(isset($this->subtipo_id))
				$query.="subtipo_id=:subtipo_id, ";
			if(isset($this->elemento_titulo))
				$query.="elemento_titulo=:elemento_titulo, ";
			if(isset($this->elemento_geolocalizacionx))
				$query.="elemento_geolocalizacionx=:elemento_geolocalizacionx, ";
			if(isset($this->elemento_geolocalizaciony))
				$query.="elemento_geolocalizaciony=:elemento_geolocalizaciony, ";
			if(isset($this->elemento_codigounico))
				$query.="elemento_codigounico=:elemento_codigounico, ";
			if(isset($this->elemento_alto))
				$query.="elemento_alto=:elemento_alto, ";
			if(isset($this->elemento_ancho))
				$query.="elemento_ancho=:elemento_ancho, ";
			if(isset($this->elemento_estado))
				$query.="elemento_estado=:elemento_estado, ";
			if(isset($this->campania_id))
				$query.="campania_id=:campania_id, ";
			if(isset($this->elemento_direccioncompleta))
				$query.="elemento_direccioncompleta=:elemento_direccioncompleta, ";
			if(isset($this->elemento_fechavencimiento))
				$query.="elemento_fechavencimiento=:elemento_fechavencimiento, ";
			if(isset($this->distrito_id))
				$query.="distrito_id=:distrito_id, ";
			if(isset($this->elemento_estavencido))
				$query.="elemento_estavencido=:elemento_estavencido, ";
			if(isset($this->cliente_id))
				$query.="cliente_id=:cliente_id, ";
			if($query!="UPDATE elemento SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE elemento_id=:elemento_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":elemento_id", $this->elemento_id,	PDO::PARAM_STR);
			if(isset($this->subtipo_id))
				$stmt->bindParam(":subtipo_id",	$this->subtipo_id,	PDO::PARAM_STR);
			if(isset($this->elemento_titulo))
				$stmt->bindParam(":elemento_titulo",	$this->elemento_titulo,	PDO::PARAM_STR);
			if(isset($this->elemento_geolocalizacionx))
				$stmt->bindParam(":elemento_geolocalizacionx",	$this->elemento_geolocalizacionx,	PDO::PARAM_STR);
			if(isset($this->elemento_geolocalizaciony))
				$stmt->bindParam(":elemento_geolocalizaciony",	$this->elemento_geolocalizaciony,	PDO::PARAM_STR);
			if(isset($this->elemento_codigounico))
				$stmt->bindParam(":elemento_codigounico",	$this->elemento_codigounico,	PDO::PARAM_STR);
			if(isset($this->elemento_alto))
				$stmt->bindParam(":elemento_alto",	$this->elemento_alto,	PDO::PARAM_STR);
			if(isset($this->elemento_ancho))
				$stmt->bindParam(":elemento_ancho",	$this->elemento_ancho,	PDO::PARAM_STR);
			if(isset($this->elemento_estado))
				$stmt->bindParam(":elemento_estado",	$this->elemento_estado,	PDO::PARAM_STR);
			if(isset($this->campania_id))
				$stmt->bindParam(":campania_id",	$this->campania_id,	PDO::PARAM_STR);
			if(isset($this->elemento_direccioncompleta))
				$stmt->bindParam(":elemento_direccioncompleta",	$this->elemento_direccioncompleta,	PDO::PARAM_STR);
			if(isset($this->elemento_fechavencimiento))
				$stmt->bindParam(":elemento_fechavencimiento",	$this->elemento_fechavencimiento,	PDO::PARAM_STR);
			if(isset($this->distrito_id))
				$stmt->bindParam(":distrito_id",	$this->distrito_id,	PDO::PARAM_STR);
			if(isset($this->elemento_estavencido))
				$stmt->bindParam(":elemento_estavencido",	$this->elemento_estavencido,	PDO::PARAM_STR);
			if(isset($this->cliente_id))
				$stmt->bindParam(":cliente_id",	$this->cliente_id,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM elemento WHERE elemento_id=:elemento_id 
			LIMIT 1");
			$stmt->bindParam(":elemento_id",	$this->elemento_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($elemento_id) {
		global $pdo;
		$sql = "SELECT * FROM elemento WHERE elemento_id=:elemento_id ";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":elemento_id",$elemento_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Elemento($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "cliente_id", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Elemento", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM elemento WHERE cliente_id != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}