<?php
class PaisEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $pais_id;
	public $pais_pais;
	public $pais_codigopostal;

	public function setPais_id($pais_id){
		$this->pais_id = $pais_id;
	}
	public function getPais_id(){
		return $this->pais_id;
	}

	public function setPais_pais($pais_pais){
		$this->pais_pais = $pais_pais;
	}
	public function getPais_pais(){
		return $this->pais_pais;
	}

	public function setPais_codigopostal($pais_codigopostal){
		$this->pais_codigopostal = $pais_codigopostal;
	}
	public function getPais_codigopostal(){
		return $this->pais_codigopostal;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->pais_pais))
				$query.="pais_pais, ";
			if(isset($this->pais_codigopostal))
				$query.="pais_codigopostal, ";
			if(isset($this->pais_pais))
				$query2.=":pais_pais, ";
			if(isset($this->pais_codigopostal))
				$query2.=":pais_codigopostal, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO pais(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->pais_pais))
				$stmt->bindParam(":pais_pais", $this->pais_pais,	PDO::PARAM_STR);
			if(isset($this->pais_codigopostal))
				$stmt->bindParam(":pais_codigopostal", $this->pais_codigopostal,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE pais SET ";
			if(isset($this->pais_pais))
				$query.="pais_pais=:pais_pais, ";
			if(isset($this->pais_codigopostal))
				$query.="pais_codigopostal=:pais_codigopostal, ";
			if($query!="UPDATE pais SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE pais_id=:pais_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":pais_id", $this->pais_id,	PDO::PARAM_STR);
			if(isset($this->pais_pais))
				$stmt->bindParam(":pais_pais",	$this->pais_pais,	PDO::PARAM_STR);
			if(isset($this->pais_codigopostal))
				$stmt->bindParam(":pais_codigopostal",	$this->pais_codigopostal,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM pais WHERE pais_id=:pais_id 
			LIMIT 1");
			$stmt->bindParam(":pais_id",	$this->pais_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($pais_id) {
		global $pdo;
		$sql = "SELECT * FROM pais WHERE pais_id=:pais_id AND pais_codigopostal != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":pais_id",$pais_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Pais($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams = array();
		return Utility::getByFields("Pais", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM pais WHERE pais_codigopostal != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}