<?php
class PermisousuarioEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $permisousuario_id;
	public $permiso_id;
	public $usuario_id;
	public $permisousuario_estado;

	public function setPermisousuario_id($permisousuario_id){
		$this->permisousuario_id = $permisousuario_id;
	}
	public function getPermisousuario_id(){
		return $this->permisousuario_id;
	}

	public function setPermiso_id($permiso_id){
		$this->permiso_id = $permiso_id;
	}
	public function getPermiso_id(){
		return $this->permiso_id;
	}

	public function setUsuario_id($usuario_id){
		$this->usuario_id = $usuario_id;
	}
	public function getUsuario_id(){
		return $this->usuario_id;
	}

	public function setPermisousuario_estado($permisousuario_estado){
		$this->permisousuario_estado = $permisousuario_estado;
	}
	public function getPermisousuario_estado(){
		return $this->permisousuario_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->permiso_id))
				$query.="permiso_id, ";
			if(isset($this->usuario_id))
				$query.="usuario_id, ";
			if(isset($this->permisousuario_estado))
				$query.="permisousuario_estado, ";
			if(isset($this->permiso_id))
				$query2.=":permiso_id, ";
			if(isset($this->usuario_id))
				$query2.=":usuario_id, ";
			if(isset($this->permisousuario_estado))
				$query2.=":permisousuario_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO permisousuario(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->permiso_id))
				$stmt->bindParam(":permiso_id", $this->permiso_id,	PDO::PARAM_STR);
			if(isset($this->usuario_id))
				$stmt->bindParam(":usuario_id", $this->usuario_id,	PDO::PARAM_STR);
			if(isset($this->permisousuario_estado))
				$stmt->bindParam(":permisousuario_estado", $this->permisousuario_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE permisousuario SET ";
			if(isset($this->permiso_id))
				$query.="permiso_id=:permiso_id, ";
			if(isset($this->usuario_id))
				$query.="usuario_id=:usuario_id, ";
			if(isset($this->permisousuario_estado))
				$query.="permisousuario_estado=:permisousuario_estado, ";
			if($query!="UPDATE permisousuario SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE permisousuario_id=:permisousuario_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":permisousuario_id", $this->permisousuario_id,	PDO::PARAM_STR);
			if(isset($this->permiso_id))
				$stmt->bindParam(":permiso_id",	$this->permiso_id,	PDO::PARAM_STR);
			if(isset($this->usuario_id))
				$stmt->bindParam(":usuario_id",	$this->usuario_id,	PDO::PARAM_STR);
			if(isset($this->permisousuario_estado))
				$stmt->bindParam(":permisousuario_estado",	$this->permisousuario_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM permisousuario WHERE permisousuario_id=:permisousuario_id 
			LIMIT 1");
			$stmt->bindParam(":permisousuario_id",	$this->permisousuario_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($permisousuario_id) {
		global $pdo;
		$sql = "SELECT * FROM permisousuario WHERE permisousuario_id=:permisousuario_id AND permisousuario_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":permisousuario_id",$permisousuario_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Permisousuario($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "permisousuario_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Permisousuario", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM permisousuario WHERE permisousuario_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}