<?php
class SubtipoEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $subtipo_id;
	public $tipo_id;
	public $subtipo_descripcion;
	public $subtipo_fecharegistro;
	public $subtipo_estado;

	public function setSubtipo_id($subtipo_id){
		$this->subtipo_id = $subtipo_id;
	}
	public function getSubtipo_id(){
		return $this->subtipo_id;
	}

	public function setTipo_id($tipo_id){
		$this->tipo_id = $tipo_id;
	}
	public function getTipo_id(){
		return $this->tipo_id;
	}

	public function setSubtipo_descripcion($subtipo_descripcion){
		$this->subtipo_descripcion = $subtipo_descripcion;
	}
	public function getSubtipo_descripcion(){
		return $this->subtipo_descripcion;
	}

	public function setSubtipo_fecharegistro($subtipo_fecharegistro){
		$this->subtipo_fecharegistro = $subtipo_fecharegistro;
	}
	public function getSubtipo_fecharegistro(){
		return $this->subtipo_fecharegistro;
	}

	public function setSubtipo_estado($subtipo_estado){
		$this->subtipo_estado = $subtipo_estado;
	}
	public function getSubtipo_estado(){
		return $this->subtipo_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->tipo_id))
				$query.="tipo_id, ";
			if(isset($this->subtipo_descripcion))
				$query.="subtipo_descripcion, ";
			if(isset($this->subtipo_fecharegistro))
				$query.="subtipo_fecharegistro, ";
			if(isset($this->subtipo_estado))
				$query.="subtipo_estado, ";
			if(isset($this->tipo_id))
				$query2.=":tipo_id, ";
			if(isset($this->subtipo_descripcion))
				$query2.=":subtipo_descripcion, ";
			if(isset($this->subtipo_fecharegistro))
				$query2.=":subtipo_fecharegistro, ";
			if(isset($this->subtipo_estado))
				$query2.=":subtipo_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO subtipo(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->tipo_id))
				$stmt->bindParam(":tipo_id", $this->tipo_id,	PDO::PARAM_STR);
			if(isset($this->subtipo_descripcion))
				$stmt->bindParam(":subtipo_descripcion", $this->subtipo_descripcion,	PDO::PARAM_STR);
			if(isset($this->subtipo_fecharegistro))
				$stmt->bindParam(":subtipo_fecharegistro", $this->subtipo_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->subtipo_estado))
				$stmt->bindParam(":subtipo_estado", $this->subtipo_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE subtipo SET ";
			if(isset($this->tipo_id))
				$query.="tipo_id=:tipo_id, ";
			if(isset($this->subtipo_descripcion))
				$query.="subtipo_descripcion=:subtipo_descripcion, ";
			if(isset($this->subtipo_fecharegistro))
				$query.="subtipo_fecharegistro=:subtipo_fecharegistro, ";
			if(isset($this->subtipo_estado))
				$query.="subtipo_estado=:subtipo_estado, ";
			if($query!="UPDATE subtipo SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE subtipo_id=:subtipo_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":subtipo_id", $this->subtipo_id,	PDO::PARAM_STR);
			if(isset($this->tipo_id))
				$stmt->bindParam(":tipo_id",	$this->tipo_id,	PDO::PARAM_STR);
			if(isset($this->subtipo_descripcion))
				$stmt->bindParam(":subtipo_descripcion",	$this->subtipo_descripcion,	PDO::PARAM_STR);
			if(isset($this->subtipo_fecharegistro))
				$stmt->bindParam(":subtipo_fecharegistro",	$this->subtipo_fecharegistro,	PDO::PARAM_STR);
			if(isset($this->subtipo_estado))
				$stmt->bindParam(":subtipo_estado",	$this->subtipo_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM subtipo WHERE subtipo_id=:subtipo_id 
			LIMIT 1");
			$stmt->bindParam(":subtipo_id",	$this->subtipo_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($subtipo_id) {
		global $pdo;
		$sql = "SELECT * FROM subtipo WHERE subtipo_id=:subtipo_id AND subtipo_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":subtipo_id",$subtipo_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Subtipo($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "subtipo_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Subtipo", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM subtipo WHERE subtipo_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}