<?php
class UsuarioEntity extends EntityBase implements DBOCrud {
	function __construct($options = array()) {
		parent::__construct($options);
	}
	public $usuario_id;
	public $usuario_usuario;
	public $usuario_clave;
	public $usuario_tipo;
	public $usuario_nombres;
	public $usuario_apellidos;
	public $usuario_dni;
	public $usuario_estado;

	public function setUsuario_id($usuario_id){
		$this->usuario_id = $usuario_id;
	}
	public function getUsuario_id(){
		return $this->usuario_id;
	}

	public function setUsuario_usuario($usuario_usuario){
		$this->usuario_usuario = $usuario_usuario;
	}
	public function getUsuario_usuario(){
		return $this->usuario_usuario;
	}

	public function setUsuario_clave($usuario_clave){
		$this->usuario_clave = $usuario_clave;
	}
	public function getUsuario_clave(){
		return $this->usuario_clave;
	}

	public function setUsuario_tipo($usuario_tipo){
		$this->usuario_tipo = $usuario_tipo;
	}
	public function getUsuario_tipo(){
		return $this->usuario_tipo;
	}

	public function setUsuario_nombres($usuario_nombres){
		$this->usuario_nombres = $usuario_nombres;
	}
	public function getUsuario_nombres(){
		return $this->usuario_nombres;
	}

	public function setUsuario_apellidos($usuario_apellidos){
		$this->usuario_apellidos = $usuario_apellidos;
	}
	public function getUsuario_apellidos(){
		return $this->usuario_apellidos;
	}

	public function setUsuario_dni($usuario_dni){
		$this->usuario_dni = $usuario_dni;
	}
	public function getUsuario_dni(){
		return $this->usuario_dni;
	}

	public function setUsuario_estado($usuario_estado){
		$this->usuario_estado = $usuario_estado;
	}
	public function getUsuario_estado(){
		return $this->usuario_estado;
	}
	public function insert() {
		try {
			global $pdo;
			$query = "";
			$query2 = "";
			if(isset($this->usuario_usuario))
				$query.="usuario_usuario, ";
			if(isset($this->usuario_clave))
				$query.="usuario_clave, ";
			if(isset($this->usuario_tipo))
				$query.="usuario_tipo, ";
			if(isset($this->usuario_nombres))
				$query.="usuario_nombres, ";
			if(isset($this->usuario_apellidos))
				$query.="usuario_apellidos, ";
			if(isset($this->usuario_dni))
				$query.="usuario_dni, ";
			if(isset($this->usuario_estado))
				$query.="usuario_estado, ";
			if(isset($this->usuario_usuario))
				$query2.=":usuario_usuario, ";
			if(isset($this->usuario_clave))
				$query2.=":usuario_clave, ";
			if(isset($this->usuario_tipo))
				$query2.=":usuario_tipo, ";
			if(isset($this->usuario_nombres))
				$query2.=":usuario_nombres, ";
			if(isset($this->usuario_apellidos))
				$query2.=":usuario_apellidos, ";
			if(isset($this->usuario_dni))
				$query2.=":usuario_dni, ";
			if(isset($this->usuario_estado))
				$query2.=":usuario_estado, ";
			$query = substr($query, 0, strlen($query) - 2);
			$query2 = substr($query2, 0, strlen($query2) - 2);
			$stmt = $pdo->prepare(
				"INSERT INTO usuario(
					".$query."
				)
				VALUES(
					".$query2."
				)"
			);
			if(isset($this->usuario_usuario))
				$stmt->bindParam(":usuario_usuario", $this->usuario_usuario,	PDO::PARAM_STR);
			if(isset($this->usuario_clave))
				$stmt->bindParam(":usuario_clave", $this->usuario_clave,	PDO::PARAM_STR);
			if(isset($this->usuario_tipo))
				$stmt->bindParam(":usuario_tipo", $this->usuario_tipo,	PDO::PARAM_STR);
			if(isset($this->usuario_nombres))
				$stmt->bindParam(":usuario_nombres", $this->usuario_nombres,	PDO::PARAM_STR);
			if(isset($this->usuario_apellidos))
				$stmt->bindParam(":usuario_apellidos", $this->usuario_apellidos,	PDO::PARAM_STR);
			if(isset($this->usuario_dni))
				$stmt->bindParam(":usuario_dni", $this->usuario_dni,	PDO::PARAM_STR);
			if(isset($this->usuario_estado))
				$stmt->bindParam(":usuario_estado", $this->usuario_estado,	PDO::PARAM_STR);
			$stmt->execute();
			if($stmt->rowCount() === 1){
				return $pdo->lastInsertId();
			}else{
				return false;
			}
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage() . "\n ". $e->getTraceAsString();
		}
	}
	public function update() {
		try {
			global $pdo;
			$query="UPDATE usuario SET ";
			if(isset($this->usuario_usuario))
				$query.="usuario_usuario=:usuario_usuario, ";
			if(isset($this->usuario_clave))
				$query.="usuario_clave=:usuario_clave, ";
			if(isset($this->usuario_tipo))
				$query.="usuario_tipo=:usuario_tipo, ";
			if(isset($this->usuario_nombres))
				$query.="usuario_nombres=:usuario_nombres, ";
			if(isset($this->usuario_apellidos))
				$query.="usuario_apellidos=:usuario_apellidos, ";
			if(isset($this->usuario_dni))
				$query.="usuario_dni=:usuario_dni, ";
			if(isset($this->usuario_estado))
				$query.="usuario_estado=:usuario_estado, ";
			if($query!="UPDATE usuario SET ")
				$query = substr($query, 0, strlen($query) - 2);
			$query.=" WHERE usuario_id=:usuario_id
				LIMIT 1";
			$stmt = $pdo->prepare(
				$query
			);
			$stmt->bindParam(":usuario_id", $this->usuario_id,	PDO::PARAM_STR);
			if(isset($this->usuario_usuario))
				$stmt->bindParam(":usuario_usuario",	$this->usuario_usuario,	PDO::PARAM_STR);
			if(isset($this->usuario_clave))
				$stmt->bindParam(":usuario_clave",	$this->usuario_clave,	PDO::PARAM_STR);
			if(isset($this->usuario_tipo))
				$stmt->bindParam(":usuario_tipo",	$this->usuario_tipo,	PDO::PARAM_STR);
			if(isset($this->usuario_nombres))
				$stmt->bindParam(":usuario_nombres",	$this->usuario_nombres,	PDO::PARAM_STR);
			if(isset($this->usuario_apellidos))
				$stmt->bindParam(":usuario_apellidos",	$this->usuario_apellidos,	PDO::PARAM_STR);
			if(isset($this->usuario_dni))
				$stmt->bindParam(":usuario_dni",	$this->usuario_dni,	PDO::PARAM_STR);
			if(isset($this->usuario_estado))
				$stmt->bindParam(":usuario_estado",	$this->usuario_estado,	PDO::PARAM_STR);
			$result=$stmt->execute();
			return $result;
		} catch (PDOException $e) {
			echo "Error: " . $e->getMessage();
		}
	}
	public function delete() {
		try {
			global $pdo;
			$stmt = $pdo->prepare("DELETE FROM usuario WHERE usuario_id=:usuario_id 
			LIMIT 1");
			$stmt->bindParam(":usuario_id",	$this->usuario_id,	PDO::PARAM_STR);
			$stmt->execute();
			return $stmt->rowCount();
		} catch (Exception $exc) {
			echo $exc->getTraceAsString();
		}
	}
	public static function getById($usuario_id) {
		global $pdo;
		$sql = "SELECT * FROM usuario WHERE usuario_id=:usuario_id AND usuario_estado != " . INACTIVO;
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(":usuario_id",$usuario_id, PDO::PARAM_STR);
		$stmt->execute();
		$stmt->setFetchMode(PDO::FETCH_ASSOC);
		$row = $stmt->fetch();
		if($row){
			return new Usuario($row);
		}else{
			return false;
		}
	}

	public static function getByFields($whereParams = array(),  $orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		$whereParams[] = array("field" => "usuario_estado", "operator" => "!=", "value" => INACTIVO);
		return Utility::getByFields("Usuario", $whereParams, $orderParams, $start, $limit);
	}

	public static function getList($orderParams = array(), $start = 0, $limit = LIMIT_RESULT) {
		return self::getByFields(array(), $orderParams, $start, $limit);
	}


	public static function getTotalRows() {
		global $pdo;
		$total_rows = 0;
		try {
			$stmt = $pdo->query("SELECT COUNT(*) FROM usuario WHERE usuario_estado != " . INACTIVO);
			$stmt->execute();
			while($row = $stmt->fetch()){
				$total_rows = $row[0];
			}
		}catch(Exception $error){
			$total_rows = 0;
		}
		return $total_rows;
	}
}