<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/archivoelemento/all","getArchivoelementoAll");
$app->get("/archivoelemento/:id","getArchivoelementoById");
$app->post("/archivoelemento","addArchivoelemento");
$app->put("/archivoelemento/:id","updateArchivoelemento");
$app->delete("/archivoelemento/:id", "deleteArchivoelemento");
$app->get("/paginado/:pagina/:registros", "getArchivoelementoListPaginado");

$app->run();

function getArchivoelementoAll() {
	$archivoelementoCtrl = new ArchivoelementoController();
	echo json_encode($archivoelementoCtrl->getAllData());
}
function getArchivoelementoById($id) {
	$archivoelementoCtrl = new ArchivoelementoController();
	echo json_encode($archivoelementoCtrl->getById($id));
}
function addArchivoelemento() {
	$request = \Slim\Slim::getInstance()->request();
	$archivoelemento = json_decode($request->getBody());
	$archivoelementoCtrl = new ArchivoelementoController();
	$array = get_object_vars($archivoelemento);
	echo json_encode($archivoelementoCtrl->add($array));
}
function updateArchivoelemento($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$archivoelemento = json_decode($body);
	$archivoelemento_vector = get_object_vars($archivoelemento);
	$archivoelementoCtrl = new ArchivoelementoController();
	echo json_encode($archivoelementoCtrl->update($id,$archivoelemento_vector));
}
function deleteArchivoelemento($id) {
	$archivoelementoCtrl = new ArchivoelementoController();
	echo json_encode($archivoelementoCtrl->delete($id));
}
function getArchivoelementoListPaginado($pagina,$registros){
	$archivoelementoCtrl = new ArchivoelementoController();
	echo json_encode($archivoelementoCtrl->getArchivoelementoListPaginado($pagina, $registros));
}

?>