<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/campania/all","getCampaniaAll");
$app->get("/campania/:id","getCampaniaById");
$app->post("/campania","addCampania");
$app->put("/campania/:id","updateCampania");
$app->delete("/campania/:id", "deleteCampania");
$app->get("/paginado/:pagina/:registros", "getCampaniaListPaginado");

$app->run();

function getCampaniaAll() {
	$campaniaCtrl = new CampaniaController();
	echo json_encode($campaniaCtrl->getAllData());
}
function getCampaniaById($id) {
	$campaniaCtrl = new CampaniaController();
	echo json_encode($campaniaCtrl->getById($id));
}
function addCampania() {
	$request = \Slim\Slim::getInstance()->request();
	$campania = json_decode($request->getBody());
	$campaniaCtrl = new CampaniaController();
	$array = get_object_vars($campania);
	echo json_encode($campaniaCtrl->add($array));
}
function updateCampania($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$campania = json_decode($body);
	$campania_vector = get_object_vars($campania);
	$campaniaCtrl = new CampaniaController();
	echo json_encode($campaniaCtrl->update($id,$campania_vector));
}
function deleteCampania($id) {
	$campaniaCtrl = new CampaniaController();
	echo json_encode($campaniaCtrl->delete($id));
}
function getCampaniaListPaginado($pagina,$registros){
	$campaniaCtrl = new CampaniaController();
	echo json_encode($campaniaCtrl->getCampaniaListPaginado($pagina, $registros));
}

?>