<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/departamento/all","getDepartamentoAll");
$app->get("/departamento/:id","getDepartamentoById");
$app->post("/departamento","addDepartamento");
$app->put("/departamento/:id","updateDepartamento");
$app->delete("/departamento/:id", "deleteDepartamento");
$app->get("/paginado/:pagina/:registros", "getDepartamentoListPaginado");

$app->run();

function getDepartamentoAll() {
	$departamentoCtrl = new DepartamentoController();
	echo json_encode($departamentoCtrl->getAllData());
}
function getDepartamentoById($id) {
	$departamentoCtrl = new DepartamentoController();
	echo json_encode($departamentoCtrl->getById($id));
}
function addDepartamento() {
	$request = \Slim\Slim::getInstance()->request();
	$departamento = json_decode($request->getBody());
	$departamentoCtrl = new DepartamentoController();
	$array = get_object_vars($departamento);
	echo json_encode($departamentoCtrl->add($array));
}
function updateDepartamento($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$departamento = json_decode($body);
	$departamento_vector = get_object_vars($departamento);
	$departamentoCtrl = new DepartamentoController();
	echo json_encode($departamentoCtrl->update($id,$departamento_vector));
}
function deleteDepartamento($id) {
	$departamentoCtrl = new DepartamentoController();
	echo json_encode($departamentoCtrl->delete($id));
}
function getDepartamentoListPaginado($pagina,$registros){
	$departamentoCtrl = new DepartamentoController();
	echo json_encode($departamentoCtrl->getDepartamentoListPaginado($pagina, $registros));
}

?>