<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/detallecampania/all","getDetallecampaniaAll");
$app->get("/detallecampania/:id","getDetallecampaniaById");
$app->post("/detallecampania","addDetallecampania");
$app->put("/detallecampania/:id","updateDetallecampania");
$app->delete("/detallecampania/:id", "deleteDetallecampania");
$app->get("/paginado/:pagina/:registros", "getDetallecampaniaListPaginado");

$app->run();

function getDetallecampaniaAll() {
	$detallecampaniaCtrl = new DetallecampaniaController();
	echo json_encode($detallecampaniaCtrl->getAllData());
}
function getDetallecampaniaById($id) {
	$detallecampaniaCtrl = new DetallecampaniaController();
	echo json_encode($detallecampaniaCtrl->getById($id));
}
function addDetallecampania() {
	$request = \Slim\Slim::getInstance()->request();
	$detallecampania = json_decode($request->getBody());
	$detallecampaniaCtrl = new DetallecampaniaController();
	$array = get_object_vars($detallecampania);
	echo json_encode($detallecampaniaCtrl->add($array));
}
function updateDetallecampania($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$detallecampania = json_decode($body);
	$detallecampania_vector = get_object_vars($detallecampania);
	$detallecampaniaCtrl = new DetallecampaniaController();
	echo json_encode($detallecampaniaCtrl->update($id,$detallecampania_vector));
}
function deleteDetallecampania($id) {
	$detallecampaniaCtrl = new DetallecampaniaController();
	echo json_encode($detallecampaniaCtrl->delete($id));
}
function getDetallecampaniaListPaginado($pagina,$registros){
	$detallecampaniaCtrl = new DetallecampaniaController();
	echo json_encode($detallecampaniaCtrl->getDetallecampaniaListPaginado($pagina, $registros));
}

?>