<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/elemento/all","getElementoAll");
$app->get("/elemento/:id","getElementoById");
$app->post("/elemento","addElemento");
$app->put("/elemento/:id","updateElemento");
$app->delete("/elemento/:id", "deleteElemento");
$app->get("/paginado/:pagina/:registros", "getElementoListPaginado");
$app->get("/paginado/:distrito/:subtipo/:vencidos", "getElementoListPaginado");

$app->run();

function getElementoAll() {
	$elementoCtrl = new ElementoController();
	echo json_encode($elementoCtrl->getAllData());
}
function getElementoById($id) {
	$elementoCtrl = new ElementoController();
	echo json_encode($elementoCtrl->getById($id));
}
function addElemento() {
	$request = \Slim\Slim::getInstance()->request();
	$elemento = json_decode($request->getBody());
	$elementoCtrl = new ElementoController();
	$array = get_object_vars($elemento);
	echo json_encode($elementoCtrl->add($array));
}
function updateElemento($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$elemento = json_decode($body);
	$elemento_vector = get_object_vars($elemento);
	$elementoCtrl = new ElementoController();
	echo json_encode($elementoCtrl->update($id,$elemento_vector));
}
function deleteElemento($id) {
	$elementoCtrl = new ElementoController();
	echo json_encode($elementoCtrl->delete($id));
}
function getElementoListPaginado($distrito,$subtipo,$vencidos){
	$elementoCtrl = new ElementoController();
	echo json_encode($elementoCtrl->getElementoListPaginado($distrito,$subtipo,$vencidos));
}

?>