<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/permiso/all","getPermisoAll");
$app->get("/permiso/:id","getPermisoById");
$app->post("/permiso","addPermiso");
$app->put("/permiso/:id","updatePermiso");
$app->delete("/permiso/:id", "deletePermiso");
$app->get("/paginado/:pagina/:registros", "getPermisoListPaginado");

$app->run();

function getPermisoAll() {
	$permisoCtrl = new PermisoController();
	echo json_encode($permisoCtrl->getAllData());
}
function getPermisoById($id) {
	$permisoCtrl = new PermisoController();
	echo json_encode($permisoCtrl->getById($id));
}
function addPermiso() {
	$request = \Slim\Slim::getInstance()->request();
	$permiso = json_decode($request->getBody());
	$permisoCtrl = new PermisoController();
	$array = get_object_vars($permiso);
	echo json_encode($permisoCtrl->add($array));
}
function updatePermiso($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$permiso = json_decode($body);
	$permiso_vector = get_object_vars($permiso);
	$permisoCtrl = new PermisoController();
	echo json_encode($permisoCtrl->update($id,$permiso_vector));
}
function deletePermiso($id) {
	$permisoCtrl = new PermisoController();
	echo json_encode($permisoCtrl->delete($id));
}
function getPermisoListPaginado($pagina,$registros){
	$permisoCtrl = new PermisoController();
	echo json_encode($permisoCtrl->getPermisoListPaginado($pagina, $registros));
}

?>