<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/provincia/all","getProvinciaAll");
$app->get("/provincia/:id","getProvinciaById");
$app->post("/provincia","addProvincia");
$app->put("/provincia/:id","updateProvincia");
$app->delete("/provincia/:id", "deleteProvincia");
$app->get("/paginado/:pagina/:registros", "getProvinciaListPaginado");

$app->run();

function getProvinciaAll() {
	$provinciaCtrl = new ProvinciaController();
	echo json_encode($provinciaCtrl->getAllData());
}
function getProvinciaById($id) {
	$provinciaCtrl = new ProvinciaController();
	echo json_encode($provinciaCtrl->getById($id));
}
function addProvincia() {
	$request = \Slim\Slim::getInstance()->request();
	$provincia = json_decode($request->getBody());
	$provinciaCtrl = new ProvinciaController();
	$array = get_object_vars($provincia);
	echo json_encode($provinciaCtrl->add($array));
}
function updateProvincia($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$provincia = json_decode($body);
	$provincia_vector = get_object_vars($provincia);
	$provinciaCtrl = new ProvinciaController();
	echo json_encode($provinciaCtrl->update($id,$provincia_vector));
}
function deleteProvincia($id) {
	$provinciaCtrl = new ProvinciaController();
	echo json_encode($provinciaCtrl->delete($id));
}
function getProvinciaListPaginado($pagina,$registros){
	$provinciaCtrl = new ProvinciaController();
	echo json_encode($provinciaCtrl->getProvinciaListPaginado($pagina, $registros));
}

?>