<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/subtipo/all","getSubtipoAll");
$app->get("/subtipo/:id","getSubtipoById");
$app->post("/subtipo","addSubtipo");
$app->put("/subtipo/:id","updateSubtipo");
$app->delete("/subtipo/:id", "deleteSubtipo");
$app->get("/paginado/:pagina/:registros", "getSubtipoListPaginado");

$app->run();

function getSubtipoAll() {
	$subtipoCtrl = new SubtipoController();
	echo json_encode($subtipoCtrl->getAllData());
}
function getSubtipoById($id) {
	$subtipoCtrl = new SubtipoController();
	echo json_encode($subtipoCtrl->getById($id));
}
function addSubtipo() {
	$request = \Slim\Slim::getInstance()->request();
	$subtipo = json_decode($request->getBody());
	$subtipoCtrl = new SubtipoController();
	$array = get_object_vars($subtipo);
	echo json_encode($subtipoCtrl->add($array));
}
function updateSubtipo($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$subtipo = json_decode($body);
	$subtipo_vector = get_object_vars($subtipo);
	$subtipoCtrl = new SubtipoController();
	echo json_encode($subtipoCtrl->update($id,$subtipo_vector));
}
function deleteSubtipo($id) {
	$subtipoCtrl = new SubtipoController();
	echo json_encode($subtipoCtrl->delete($id));
}
function getSubtipoListPaginado($pagina,$registros){
	$subtipoCtrl = new SubtipoController();
	echo json_encode($subtipoCtrl->getSubtipoListPaginado($pagina, $registros));
}

?>