<?php

define("PATH", "../../");
require PATH . "config.php";
$app = new \Slim\Slim();
$app->contentType("application/json");
/**
* ROUTERS
*/
$app->get("/tipo/all","getTipoAll");
$app->get("/tipo/:id","getTipoById");
$app->post("/tipo","addTipo");
$app->put("/tipo/:id","updateTipo");
$app->delete("/tipo/:id", "deleteTipo");
$app->get("/paginado/:pagina/:registros", "getTipoListPaginado");

$app->run();

function getTipoAll() {
	$tipoCtrl = new TipoController();
	echo json_encode($tipoCtrl->getAllData());
}
function getTipoById($id) {
	$tipoCtrl = new TipoController();
	echo json_encode($tipoCtrl->getById($id));
}
function addTipo() {
	$request = \Slim\Slim::getInstance()->request();
	$tipo = json_decode($request->getBody());
	$tipoCtrl = new TipoController();
	$array = get_object_vars($tipo);
	echo json_encode($tipoCtrl->add($array));
}
function updateTipo($id) {
	$request = \Slim\Slim::getInstance()->request();
	$body = $request->getBody();
	$tipo = json_decode($body);
	$tipo_vector = get_object_vars($tipo);
	$tipoCtrl = new TipoController();
	echo json_encode($tipoCtrl->update($id,$tipo_vector));
}
function deleteTipo($id) {
	$tipoCtrl = new TipoController();
	echo json_encode($tipoCtrl->delete($id));
}
function getTipoListPaginado($pagina,$registros){
	$tipoCtrl = new TipoController();
	echo json_encode($tipoCtrl->getTipoListPaginado($pagina, $registros));
}

?>