<?php
header('Content-Type: text/plain; charset=utf-8');

echo "=== DEBUGGING IMAGEWORKSHOP ===\n\n";

$file = __DIR__ . '/api/core/libs/PHPImageWorkshop/ImageWorkshop.php';

echo "1. File exists: " . (file_exists($file) ? 'YES' : 'NO') . "\n";
echo "2. File path: $file\n";
echo "3. File modified: " . date('Y-m-d H:i:s', filemtime($file)) . "\n\n";

echo "4. Reading lines 72-85:\n";
echo "---START---\n";
$lines = file($file);
for ($i = 71; $i < 85; $i++) {
    echo ($i + 1) . ": " . $lines[$i];
}
echo "---END---\n\n";

echo "5. Checking for backslash in line 74:\n";
$line74 = $lines[73]; // Array is 0-indexed
echo "Line 74: " . $line74;
if (strpos($line74, '\imagecreatefromjpeg') !== false) {
    echo "✓ CORRECT: Contains \\imagecreatefromjpeg\n";
} elseif (strpos($line74, 'imagecreatefromjpeg') !== false) {
    echo "✗ WRONG: Contains imagecreatefromjpeg (without backslash)\n";
} else {
    echo "? UNKNOWN: Line doesn't contain expected function\n";
}

echo "\n6. Testing GD functions:\n";
echo "function_exists('imagecreatefromjpeg'): " . (function_exists('imagecreatefromjpeg') ? 'YES' : 'NO') . "\n";
echo "function_exists('\\imagecreatefromjpeg'): " . (function_exists('\\imagecreatefromjpeg') ? 'YES' : 'NO') . "\n";

echo "\n7. OPcache info:\n";
if (function_exists('opcache_get_status')) {
    $status = opcache_get_status();
    echo "OPcache enabled: " . ($status['opcache_enabled'] ? 'YES' : 'NO') . "\n";
    if ($status['opcache_enabled']) {
        echo "Clearing OPcache...\n";
        opcache_reset();
        echo "OPcache cleared!\n";
    }
} else {
    echo "OPcache not available\n";
}

echo "\n8. Testing ImageWorkshop load:\n";
try {
    require_once __DIR__ . '/api/config.php';
    use PHPImageWorkshop\ImageWorkshop as ImageWorkshop;
    
    // Create a tiny test image
    $testDir = __DIR__ . '/imagenElemento/';
    if (!is_dir($testDir)) {
        mkdir($testDir, 0777, true);
    }
    
    $testFile = $testDir . 'debug_test.jpg';
    $img = imagecreate(10, 10);
    imagecolorallocate($img, 255, 0, 0);
    imagejpeg($img, $testFile);
    imagedestroy($img);
    
    echo "Created test image: $testFile\n";
    echo "Attempting ImageWorkshop::initFromPath()...\n";
    
    $layer = ImageWorkshop::initFromPath('imagenElemento/debug_test.jpg');
    echo "✓ SUCCESS! ImageWorkshop loaded the image.\n";
    
    unlink($testFile);
} catch (Exception $e) {
    echo "✗ FAILED: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n=== END DEBUG ===\n";
