<?php
/**
 * HABILITAR ERRORES TEMPORAL - SOLO PARA DEPURACIÓN
 * 
 * ADVERTENCIA: Este archivo muestra errores PHP en pantalla.
 * USAR SOLO PARA DEPURACIÓN EN PRODUCCIÓN POR TIEMPO LIMITADO
 * ELIMINAR INMEDIATAMENTE DESPUÉS DE IDENTIFICAR EL PROBLEMA
 * 
 * INSTRUCCIONES:
 * 1. Subir este archivo a: /publicidadpaneles/habilitar_errores_temporal.php
 * 2. Modificar index.php para incluir este archivo AL INICIO
 * 3. Intentar reproducir el error 500
 * 4. Ver el error específico en pantalla
 * 5. ELIMINAR este archivo y la línea de include después
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('log_errors', 1);

// Log adicional
ini_set('error_log', __DIR__ . '/logs/php_errors_' . date('Y-m-d') . '.log');

// Capturar errores fatales
register_shutdown_function(function() {
    $error = error_get_last();
    if ($error && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        echo '<div style="background: #f8d7da; border: 2px solid #f5c6cb; color: #721c24; padding: 20px; margin: 20px; font-family: monospace;">';
        echo '<h2>❌ ERROR FATAL DETECTADO</h2>';
        echo '<strong>Tipo:</strong> ' . $error['type'] . '<br>';
        echo '<strong>Mensaje:</strong> ' . htmlspecialchars($error['message']) . '<br>';
        echo '<strong>Archivo:</strong> ' . htmlspecialchars($error['file']) . '<br>';
        echo '<strong>Línea:</strong> ' . $error['line'] . '<br>';
        echo '</div>';
    }
});

echo '<div style="background: #fff3cd; border: 2px solid #ffc107; color: #856404; padding: 10px; margin: 10px; font-family: Arial;">';
echo '⚠ <strong>MODO DEPURACIÓN ACTIVO</strong> - Los errores se mostrarán en pantalla';
echo '</div>';
?>
